/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.4.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2005,2006,2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2005,2006,2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    MatOoLbox-test belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type MatOoLbox test
#endif

#ifndef __materials_toolbox_test_hpp
#define __materials_toolbox_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __parameters_h
#include "parameters.h"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __tensors2_hpp
#include "MOL++/tensors2.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __materials_toolbox_hpp
#include "MateriOL++/MatOoLbox.hpp"
#endif

#ifndef __isotropic_elasticity_tensors_hpp
#include "MateriOL++/isotropic elasticity tensors.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace materiol;


//=============================
int test_MatOoLbox (int detail)
//=============================
{
  int result=1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                    MatOoLbox test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  tensor2<long double> Id =& kronecker<long double>(3);
  tensor2<long double> stress(3,3);
  long double sc = 1;
  sc /= 3;
  stress(1,1) = 125.4567;
  stress(2,2) = 23.56;
  stress(3,3) = 32.341;
  stress(1,2) = stress(2,1) = -15.234;
  stress(1,3) = 24.567;
  stress(3,1) = -23.67;
  stress(2,3) = -27.1234;
  stress(3,2) = 61.345;

  if (detail) affiche ("Von Mises equivalent stress", abs(sqrt((long double) 1.5*(stress-sc*tr(stress)*Id)|(stress-sc*tr(stress)*Id)) - Von_Mises_stress(stress)) < epsilon);
  else result *= ( abs (sqrt((long double) 1.5*(stress-tr(stress)*Id)|(stress-tr(stress)*Id)) == Von_Mises_stress(stress)) < epsilon);

  tensor2<long double> strain = stress;
  if (detail) affiche ("Von Mises equivalent strain", abs(sqrt((long double) 2*sc*(strain|strain)) - Von_Mises_strain(strain)) < epsilon);
  else result *= (abs(sqrt((long double) 2*sc*(strain|strain)) - Von_Mises_strain(strain)) < epsilon);

  isotropic_elasticity_tensor<long double> C;
  C.Lame(120000);
  C.Shear(80000);
  tensor2<long double> M(3,3);
  M(1,1) = 4; M(1,2) = -1; M(1,3) = 8;
  M(2,1) = -2; M(2,3) = 7;
  M(3,1) = M(3,2) = 0.5; M(3,3) = 9;
  long double To = 27.85*0;

  isotropic_elasticity_tensor<long double> S = C.inv();
  stress(1,3) = stress(3,1);
  stress(3,2) = stress(2,3);
  strain = constitutive_equation(S, S||M, stress, To, 1);
  if (detail) affiche ("constitutive equation", strain == ((S||stress) + (S||M)*To) && stress == constitutive_equation(C,M,strain,To,-1));
  else result *= (strain == ((S||stress) + (S||M)*To) && stress == constitutive_equation(C,M,strain,To,-1));

  matrix<long double> P, P1(3,3), P2(3,3), P3(3,3);
  long double phi1=73.464, phi=104.504, phi2=34.5;
  P1(1,1) = P1(2,2) = cos(phi1);
  P1(2,1) = sin(phi1);
  P1(1,2) = -P1(2,1);
  P2(2,2) = P2(3,3) = cos(phi);
  P2(3,2) = sin(phi);
  P2(2,3) = -P2(3,2);
  P3(1,1) = P3(2,2) = cos(phi2);
  P3(2,1) = sin(phi2);
  P3(1,2) = -P3(2,1);
  P1(3,3) = P2(1,1) = P3(3,3) = 1;
  P = P1 * P2 * P3;

  if (detail) affiche ("local2global basis", P == local2global_basis(phi1,phi,phi2));
  else result *= (P == local2global_basis(phi1,phi,phi2));

  if (detail) affiche ("global2local basis", t(P) == global2local_basis(phi1,phi,phi2));
  else result *= (t(P) == global2local_basis(phi1,phi,phi2));
  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                    MatOoLbox test passed" << reset;
  else cout << red << "                    MatOoLbox test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
