/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.4.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2005,2006,2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2005,2006 BERBENNI Stephane
 * copyright © 2005,2006,2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    tests-materials belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type tests-MateriOL++
#endif

#ifndef __iomanip
#include <iomanip>
#endif

#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __assert_h
#include <assert.h>
#endif

#ifndef __time_h
#include <time.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __isotropic_tensors_test_hpp
#include "isotropic tensors-test.hpp"
#endif

#ifndef __isotropic_elasticity_tensors_test_hpp
#include "isotropic elasticity tensors-test.hpp"
#endif

#ifndef __cubic_tensors_test_hpp
#include "cubic tensors-test.hpp"
#endif

#ifndef __cubic_elasticity_tensors_test_hpp
#include "cubic elasticity tensors-test.hpp"
#endif

#ifndef __orthotropic_tensors_test_hpp
#include "orthotropic tensors-test.hpp"
#endif

#ifndef __transversely_isotropic_tensors_test_hpp
#include "transversely isotropic tensors-test.hpp"
#endif

#ifndef __transversely_isotropic_elastic_tensors_test_hpp
#include "transversely isotropic elastic tensors-test.hpp"
#endif

#ifndef __TII_test_hpp
#include "TII-test.hpp"
#endif

#ifndef __PII_test_hpp
#include "PII-test.hpp"
#endif

//#if !defined(__TIJ_TEST_H)
//#include"materials/TIJ-test.h"
//#endif

#ifndef __Eshelby_test_hpp
#include "Eshelby-test.hpp"
#endif

#ifndef __Schmid_tensor_test_hpp
#include "Schmid tensor-test.hpp"
#endif

#ifndef __systems_test_hpp
#include "systems-test.hpp"
#endif

#ifndef __loading_test_hpp
#include "loading-test.hpp"
#endif

#ifndef __materials_toolbox_test_hpp
#include "MatOoLbox-test.hpp"
#endif

#ifndef __walpole_test_hpp
#include "walpole-test.hpp"
#endif

using namespace std;


main()
{
  int detail; // parameter to write/hide test procedure
  bool result = true;
  clock_t start, end;
  clock_t start_main, end_main;

  detail = 0;
  start_main = start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "-----------------------isotropic tensor---------------------- \n";
    //=======================================================================
  result *= test_isotropic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "-----------------isotropic elasticity tensor----------------- \n";
    //=======================================================================
  result *= test_isotropic_elasticity_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "------------------------cubic tensor------------------------- \n";
    //=======================================================================
  result *= test_cubic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "-------------------cubic elasticity tensor------------------- \n";
    //=======================================================================
  result *= test_cubic_elasticity_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "----------------------orthotropic tensor----------------------\n";
    //=======================================================================
  result *= test_orthotropic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "----------------transversely isotropic tensor---------------- \n";
    //=======================================================================
  result *= test_transversely_isotropic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "------------transversely isotropic elastic tensor------------ \n";
    //=======================================================================
  result *= test_transversely_isotropic_elastic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "-----------------------------TII----------------------------- \n";
    //=======================================================================
  result *= test_TII(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "-----------------------------PII----------------------------- \n";
    //=======================================================================
  result *= test_PII(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  /*
  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-----------------------------TIJ----------------------------- \n";
    //=======================================================================
  result *= test_TIJ(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;
  */

  detail = 1;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "---------------------------Eshelby--------------------------- \n";
    //=======================================================================
  result *= test_Eshelby(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "------------------------Schmid tensor------------------------ \n";
    //=======================================================================
  result *= test_Schmid_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "---------------------------systems--------------------------- \n";
    //=======================================================================
  result *= test_systems(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "---------------------------loading--------------------------- \n";
    //=======================================================================
  result *= test_loading(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "--------------------------MatOolbox-------------------------- \n";
    //=======================================================================
  result *= test_MatOoLbox(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "---------------------------walpole--------------------------- \n";
    //=======================================================================
  result *= test_walpole(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  end_main = clock();

  cout << "============================================================== \n";
  if (result) cout << green << "-------OK-----------end of MateriOL++ tests-----------OK------" << reset;
  else cout << red << "-----FAILED---------end of MateriOL++ tests---------FAILED----" << reset;
  cout << "============================================================== \n";

  cout<<"cpu time : " << (long double)(end_main-start_main)/CLOCKS_PER_SEC << endl;
}
