/***************************************************************
 *            Declaration for Simula+ utility tools            *
 *                 christophe.collard@cemes.fr                 *
 *                   GNU/linux version 3.4.0                   *
 ***************************************************************
 * copyright © 2010,2011,2012,2013 COLLARD Christophe
 * copyright © 2010,2011,2012,2013 Centre National de la Recherche Scientifique
 * copyright © 2010 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2010,2011,2012,2013 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*! \class security
    \brief security test
    \author copyright \htmlonly &#169; \endhtmlonly 2010, 2011, 2012, 2013 Christophe COLLARD \n
            copyright \htmlonly &#169; 2010, 2011, 2012, 2013 Centre National de la Recherche Scientifique \endhtmlonly \n
	    copyright \htmlonly &#169; \endhtmlonly 2010 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS) \n
            copyright \htmlonly &#169; 2010, 2011, 2012, 2013 Centre d'Elaboration de Mat&#233;riaux et d'Etudes Structurales (CEMES - CNRS) \endhtmlonly \n
    \version 3.4.0
    \date 2010-2019
    \bug none
    \warning none
*/

#ifndef __cplusplus
#error Must use C++ for the type security
#endif

#ifndef __tools_hpp
#define __tools_hpp


#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __iostream
#include <iostream>
#endif

#ifndef __fstream
#include <fstream>
#endif

#ifndef __string
#include <string>
#endif

#ifndef __time_h
#include <time.h>
#endif

#ifndef __assert_h
#include <assert.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

using namespace std;


/*!
  \brief Read next value in a file with comments.

  \param file stream on file
  \param path filename (not necessary but useful to resolve errors)
  \return value
*/

//---------------------------------------------------------------------
template <class T> T read_value (ifstream& file, const char* path = "")
//---------------------------------------------------------------------
{
  T value;
  string text;
  int loops = 0;

  for (char ch=file.peek(); !isdigit(ch) && ch!='+' && ch!='-' && ch!='.'; ch=file.peek(), loops++)
    if (loops < 100)
      if (ch == ' ') file.get();
      else getline (file, text);
    else
      { cout << red << "error: wrong file format ";
	if (path != "") cout << "in " << path << reset;
	else cout << "(no information on filename provided to function read_value)" << reset;
	exit(1);
      }

  file >> value;

  return value;
}


/*!
  \brief Add a value to a file.

  \param path filename
  \ data dato to write to the file
*/

//------------------------------------------------------------
template <class T> void write_value (const char* path, T data)
//------------------------------------------------------------
{
  ofstream file (path, ios::app);
  assert (!file.fail());
  file << setprecision(15) << data;
  file.close();
}


/*!
  \brief Try to read a value into a file after a crash.

  \param file stream on file
  \ data dato to write to the file
  \return true is the operation succeded, false elsewhere.
*/

//-------------------------------------------------------------
template <class T> bool restore_value (ifstream& file, T& data)
//-------------------------------------------------------------
{
  bool read = true;
  string text;
  int loops = 0;

  for (char ch=file.peek(); !isdigit(ch) && ch!='+' && ch!='-' && ch!='.' && read; ch=file.peek(), loops++)
    if (loops < 100)
      if (ch == ' ') file.get();
      else getline (file, text);
    else
      { cout << magenta << "end of restoration " << reset;
	read = false;
      }

  if (read) file >> data;

  return read;
}




#endif
