/*- <matfquad/net/socket/Protocol.hpp> -*- C++ -*-
 *
 *
 *  matfquad
 *  Copyright (C) 2012  Márcio Adriano Tavares Fernandes
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
#ifndef __MATFQUAD_NET_SOCKET_PROTOCOL_HPP__
#define __MATFQUAD_NET_SOCKET_PROTOCOL_HPP__
#include "Parameter.hpp"

namespace matfquad
{
namespace net
{
namespace socket
{
class Protocol: public Parameter
{
 protected:
  static std::vector <Protocol *> list;
 public:
  Protocol();
  Protocol(int number);
  Protocol(int number, std::string name);
  Protocol(int number, std::string name, std::vector <std::string> nickname);
  ~Protocol();
};

class Protocol_IP: public Protocol
{
 private:
  static Protocol_IP instance;
  Protocol_IP();
 public:
  static Protocol *getInstance();
};

class Protocol_TCP: public Protocol
{
 private:
  static Protocol_TCP instance;
  Protocol_TCP();
 public:
  static Protocol *getInstance();
};

class Protocol_UDP: public Protocol
{
 private:
  static Protocol_UDP instance;
  Protocol_UDP();
 public:
  static Protocol *getInstance();
};
}
}
}

#endif
