/*- <matfquad/net/socket/Protocol.cpp> -*- C++ -*-
 *
 *
 *  matfquad
 *  Copyright (C) 2012  Márcio Adriano Tavares Fernandes
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
#include "matfquad/net/socket/Protocol.hpp"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
using namespace matfquad::net::socket;

// #############################################################################
// # Protocol ##################################################################
// #############################################################################
std::vector <Protocol *> Protocol::list;

Protocol::Protocol(): Parameter()
{
}

Protocol::Protocol(int number): Parameter(number)
{
  for ( size_t i = 0; Protocol::list.size() > i; i++ )
  {
    if ( Protocol::list.at(i)->getNumber() == number )
    {
      this->name = Protocol::list.at(i)->getName();
      this->nicknames = Protocol::list.at(i)->getNicknames();
      i = Protocol::list.size();
    }
  }
}

Protocol::Protocol(int number, std::string name): Parameter(number, name)
{
}

Protocol::Protocol(int number, std::string name, std::vector <std::string> nickname): Parameter(number, name, nickname)
{
}

Protocol::~Protocol()
{
  for ( size_t i = 0; Protocol::list.size() > i; i++ )
  {
    if ( Protocol::list.at(i) == this )
    {
      Protocol::list.erase(Protocol::list.begin()+i);
    }
  }
}

// #############################################################################
// # Protocol IP ###############################################################
// #############################################################################
Protocol_IP Protocol_IP::instance;

Protocol_IP::Protocol_IP(): Protocol(IPPROTO_IP, "IP")
{
  Protocol::list.push_back(this);
}

Protocol *Protocol_IP::getInstance()
{
  return &Protocol_IP::instance;
}

// #############################################################################
// # Protocol TCP ##############################################################
// #############################################################################
Protocol_TCP Protocol_TCP::instance;

Protocol_TCP::Protocol_TCP(): Protocol(IPPROTO_TCP, "TCP")
{
  this->nicknames.push_back("Transmission Control Protocol");
  Protocol::list.push_back(this);
}

Protocol *Protocol_TCP::getInstance()
{
  return &Protocol_TCP::instance;
}

// #############################################################################
// # Protocol UDP ##############################################################
// #############################################################################
Protocol_UDP Protocol_UDP::instance;

Protocol_UDP::Protocol_UDP(): Protocol(IPPROTO_UDP, "UDP")
{
  this->nicknames.push_back("User Datagram Protocol");
  Protocol::list.push_back(this);
}

Protocol *Protocol_UDP::getInstance()
{
  return &Protocol_UDP::instance;
}
