/*- <matfquad/net/socket/Family.cpp> -*- C++ -*-
 *
 *
 *  matfquad
 *  Copyright (C) 2012  Márcio Adriano Tavares Fernandes
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
#include "matfquad/net/socket/Family.hpp"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
using namespace matfquad::net::socket;

// #############################################################################
// # Family ####################################################################
// #############################################################################
std::vector <Family *> Family::list;

Family::Family(): Parameter()
{
}

Family::Family(int number): Parameter(number)
{
  for ( size_t i = 0; Family::list.size() > i; i++ )
  {
    if ( Family::list.at(i)->getNumber() == number )
    {
      this->name = Family::list.at(i)->getName();
      this->nicknames = Family::list.at(i)->getNicknames();
      i = Family::list.size();
    }
  }
}

Family::Family(int number, std::string name): Parameter(number, name)
{
}

Family::Family(int number, std::string name, std::vector <std::string> nickname): Parameter(number, name, nickname)
{
}

Family::~Family()
{
  for ( size_t i = 0; Family::list.size() > i; i++ )
  {
    if ( Family::list.at(i) == this )
    {
      Family::list.erase(Family::list.begin()+i);
    }
  }
}

// #############################################################################
// # Family INET ###############################################################
// #############################################################################
Family_INET Family_INET::instance;

Family_INET::Family_INET(): Family(AF_INET, "INET")
{
  Family::list.push_back(this);
}

Family *Family_INET::getInstance()
{
  return &Family_INET::instance;
}

// #############################################################################
// # Family INET6 ##############################################################
// #############################################################################
Family_INET6 Family_INET6::instance;

Family_INET6::Family_INET6(): Family(AF_INET6, "INET6")
{
  Family::list.push_back(this);
}

Family *Family_INET6::getInstance()
{
  return &Family_INET6::instance;
}
