/*- <matfquad/net/socket/Type.cpp> -*- C++ -*-
 *
 *
 *  matfquad
 *  Copyright (C) 2012  Márcio Adriano Tavares Fernandes
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
#include "matfquad/net/socket/Type.hpp"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
using namespace matfquad::net::socket;

// #############################################################################
// # Type ######################################################################
// #############################################################################
std::vector <Type *> Type::list;

Type::Type(): Parameter()
{
}

Type::Type(int number): Parameter(number)
{
  for ( size_t i = 0; Type::list.size() > i; i++ )
  {
    if ( Type::list.at(i)->getNumber() == number )
    {
      this->name = Type::list.at(i)->getName();
      this->nicknames = Type::list.at(i)->getNicknames();
      i = Type::list.size();
    }
  }
}

Type::Type(int number, std::string name): Parameter(number, name)
{
}

Type::Type(int number, std::string name, std::vector <std::string> nickname): Parameter(number, name, nickname)
{
}

Type::~Type()
{
  for ( size_t i = 0; Type::list.size() > i; i++ )
  {
    if ( Type::list.at(i) == this )
    {
      Type::list.erase(Type::list.begin()+i);
    }
  }
}

// #############################################################################
// # Type DGRAM ################################################################
// #############################################################################
Type_DGRAM Type_DGRAM::instance;

Type_DGRAM::Type_DGRAM(): Type(SOCK_DGRAM, "DGRAM")
{
  Type::list.push_back(this);
}

Type *Type_DGRAM::getInstance()
{
  return &Type_DGRAM::instance;
}

// #############################################################################
// # Type STREAM ###############################################################
// #############################################################################
Type_STREAM Type_STREAM::instance;

Type_STREAM::Type_STREAM(): Type(SOCK_STREAM, "STREAM")
{
  Type::list.push_back(this);
}

Type *Type_STREAM::getInstance()
{
  return &Type_STREAM::instance;
}
