// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <wx/frame.h>
#include <wx/panel.h>

#include <config.h>
#include "checksetup.h"

#include "module.h"
#include "windowcontents.h"

class MainWindow: public wxFrame
{
public:
  MainWindow() throw(Exception);

  // File menu
  void OnExit(wxCommandEvent &event) throw();
  void OnOpen(wxCommandEvent &event) throw();
  void OnSave(wxCommandEvent &event) throw();

  // Debug menu
#ifdef __WXDEBUG__
  void OnMenuReplace(wxCommandEvent &event) throw();
#endif

  void OnReplace(wxCommandEvent &event) throw();
  void OnClose(wxCloseEvent &event) throw();
  
  void ReplaceSoon(const wxString &room) throw();

  friend class Application;

protected:
  DECLARE_EVENT_TABLE()

private:
  wxPanel *m_panel;
};

enum { ID_REPLACE = wxID_HIGHEST + 1,
       MENU_REPLACE,
       ID_HIGHEST = wxID_HIGHEST + 1000 };
    

#endif // MAINWINDOW_H

// 
// Local Variables:
// mode: c++
// End:
