// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/intl.h>
#include <wx/txtstrm.h>
#include <wx/wfstream.h>
#include <wx/tokenzr.h>

#include <config.h>
#include "../checksetup.h"

#include "multsim.h"
#include "multsimdata.h"
#include "../application.h"

MultSimData::MultSimData(MultSim* ms, const wxExpr *expr)
  throw(Exception):
    m_ms(ms)
{
  wxLogDebug("Constructing MultSimData.");
  wxASSERT(ms != NULL);
  wxASSERT(expr != NULL);

  // Get the number of columns
  {
    if(! expr->GetAttributeValue("columns", m_columns) ||
       ! expr->GetAttributeValue("rows", m_rows))
    {
      throw NoisyException
	(_("Malformed item in room list: the multsim module\n"
	   "requires one attribute named \"columns\" and\n"
	   "one attribute named \"rows\" (both integers)."));
    }
  }
  
  // Get the file with the data
  {
    wxString filename;
    try
    {
      GetLocalizedAttribute(expr, "data_file", filename);
    }
    catch(Exception &ex)
    {
      throw NoisyException(_("Malformed item in room list: the multsim "
			     "module requires an attribute named "
			     "\"file_data\"."));
    }
   
    filename = GetApp()->config->GetModuleDataFile(filename);

    wxFileInputStream input(filename.c_str());
    wxTextInputStream text(input);
    
    // File format:
    // QUESTION1 # ANSWER1
    // QUESTION2 # ANSWER2
    // 3 x 3 = # 9

    wxString line;
    wxStringTokenizer tkz;
    int n = 0;
    m_questions.Alloc(m_columns * m_rows);
    m_answers.Alloc(m_columns * m_rows);
    while(!input.Eof() && n < m_columns * m_rows)
    {
      line = text.ReadLine();
      if(line != wxEmptyString)
      {
	tkz.SetString(line, "#");
	if(tkz.CountTokens() != 2)
	{
	  wxLogWarning(_("Error in file \"%s\": line has wrong format."),
		       filename.c_str());
	}
	else
	{
	  // Strip(wxString::both) removes leading and trailing whitespace
	  m_questions.Add(from_utf8(tkz.GetNextToken().Strip(wxString::both)));
	  m_answers.Add(from_utf8(tkz.GetNextToken().Strip(wxString::both)));
	  n++;
	}
      }
    }
    
    if(n != m_columns * m_rows)
    {
      throw NoisyException
	(wxString::Format(_("To few entries in file \"%s\" (must be %d)."),
			  filename.c_str(), m_columns * m_rows));
    }
  }
}
