// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/memory.h>
#include <new>

#include <config.h>
#include "../checksetup.h"

#include "../application.h"
#include "../htmlpanel.h"
#include "../introwc.h"
#include "chooseone.h"
#include "chooseonepanel.h"

extern "C" char *version(void)
{
  return PACKAGE_STRING;
}

extern "C" char *type(void)
{
  return "WindowContents";	// This is a WindowContents object
}

void ChooseOne::Init(const wxExpr *ex,
		     wxPanel *panel) throw(Exception)
try
{
  wxLogTrace("entering", "ChooseOne::Init()");

  //  wxLog::AddTraceMask("ChooseOneBitmap");

  try
  {
    GetApp()->GetCurrentWC()->Destroy();
  }
  catch(NullException &ex) {} 	// harmless, there is no current wc.

  IntroWC::Init(ex, panel);

  wxString filename;
  try
  {
    GetLocalizedAttribute(expr, "control_file", filename); 
    filename = GetApp()->config->GetModuleDataFile(filename);
  }
  catch(Exception &ex)
  {
    throw NoisyException("Malformed item in room list: this "
			 "module requires the attribute "
			 "\"control_file\". This file should "
			 "be in the same directory as the module.");
  }

  m_data = new ChooseOneData(filename, this);

  wxString theme_name;
  expr->GetAttributeValue("theme", theme_name);
  if(theme_name != wxEmptyString)
    m_theme = new Theme(theme_name);
  else
    m_theme = NULL;
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

void ChooseOne::ReloadPanel() throw()
try
{
  if(m_panel != NULL)
  {
    m_panel->Destroy();
  }
  m_panel = new ChooseOnePanel(this, m_data);
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

void ChooseOne::EnterRoom() throw(Exception)
try
{
  wxLogTrace("entering", "ChooseOne::EnterRoom()");

  m_panel = new ChooseOnePanel(this, m_data);
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

wxExpr* ChooseOne::cHibernate() throw(Exception)
try
{
  wxASSERT(m_data != NULL);
  wxASSERT(expr != NULL);

  m_data->SaveData(expr->Functor() + "_data");
  return expr->Copy();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

void ChooseOne::Destroy() throw()
{
  wxLogTrace("entering", "ChooseOne::Destroy(): clearing window.");
  
  main_panel->DestroyChildren(); 

  if(m_theme != NULL)
  {
    delete m_theme;
    m_theme = NULL;
  }

  if(m_data != NULL)
  {
    delete m_data;
    m_data = NULL;
  }
}

namespace
{
  void Restarter::operator()() throw()
  {
    m_co->ReloadPanel();
  }
}

// The class factories

extern "C" WindowContents* create(void)
{
  wxLogTrace("entering", "ChooseOne factory.");
  return new(std::nothrow) ChooseOne();
}

extern "C" void destroy(WindowContents *w)
{
  wxLogTrace("entering", "WindowContents destruction callback");
  delete w;
}
