// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef CHOOSEONE_H
#define CHOOSEONE_H

#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/panel.h>

#include <config.h>
#include "../checksetup.h"

class ChooseOne;

#include "../application.h"
#include "../introwc.h"
#include "../theme.h"
#include "chooseonepanel.h"
#include "chooseonedata.h"

// The CooseOne class is a WindowContents class that displays an image
// and presents the user with some choices. Normally the image would
// contain a question of some sort.
//
// It needs to have a ChooseOne file, saying what images to display
// and what choices are available.

namespace
{
  class Restarter: public CommandProcessor
  {
  public:
    Restarter(ChooseOne *co) throw(): m_co(co) {}

    void operator()() throw();
  private:
    ChooseOne* m_co;
  };
}


class ChooseOne: public IntroWC
{
public:
  ChooseOne() throw(): m_panel(NULL), m_data(NULL), m_restarter(this) {}

  virtual void Init(const wxExpr *expr,
		    wxPanel *panel) throw(Exception);

  void EnterRoom() throw(Exception);

  virtual void Destroy() throw();

  void ReloadPanel() throw();

  virtual wxExpr* cHibernate() throw(Exception);

  friend class ChooseOnePanel;
private:
  ChooseOnePanel *m_panel;
  ChooseOneData *m_data;

  Restarter m_restarter;

  Theme *m_theme;
};

#endif // CHOOSEONE_H

// 
// Local Variables:
// mode: c++
// End:
