// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/layout.h>
#include <wx/textctrl.h>
#include <wx/intl.h>
#include <wx/html/htmlwin.h>

#include <config.h>
#include "checksetup.h"

#include "application.h"
#include "button.h"
#include "htmlpanel.h"
#include "windowcontents.h"

HtmlPanel::HtmlPanel(WindowContents *wc,          // The WindowContents object
		     const wxString &html_file,   // The HTML file to display
		     const wxString &button_text, // The text on the button
		     const wxString &button_help,  // Help text for the button
		     CommandProcessor &cp         // A function-like object or a callback function
		     ) throw(Exception) try:
  m_wc(wc),
  m_cp(cp),
  wxPanel(wc->main_panel, -1,
	  wxDefaultPosition, wc->main_panel->GetClientSize(),
	  wxTAB_TRAVERSAL)
{
  wxLogTrace("entering", "HtmlPanel constructor...");

  // wxWS_EX_TRANSIENT: This can be used to prevent a window from
  // being used as an implicit parent for the dialogs which were
  // created without a parent. It is useful for the windows which can
  // disappear at any moment as creating children of such windows
  // results in fatal problems.
  SetExtraStyle(wxWS_EX_TRANSIENT);

  wxBoxSizer *hsizer = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer *vsizer = new wxBoxSizer(wxVERTICAL);

  wxHtmlWindow *htmlwin = new wxHtmlWindow(this);
  vsizer->Add(htmlwin, 1, wxEXPAND | wxALL, 10);

  wxButton *button = new Button(this, HTMLPANEL_BUTTON, button_text);

  if(button_help != wxEmptyString)
  {
    button->SetToolTip(button_help);
    button->SetHelpText(button_help);
  }
  vsizer->Add(button, 0, wxCENTER | wxALL, 10);

  htmlwin->LoadPage(html_file);

  hsizer->Add(vsizer, 1, wxEXPAND);

  button->SetFocus();
  SetDefaultItem(button);
  this->SetSizerAndFit(hsizer);

  wxBoxSizer *main_sizer = new wxBoxSizer(wxHORIZONTAL);
  main_sizer->Add(this, 1, wxEXPAND, 0);
  wc->main_panel->SetSizer(main_sizer);

  wc->main_panel->Layout();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

HtmlPanel::~HtmlPanel() throw()
{
  wxLogTrace("entering", "HtmlPanel destructor.");

  // We have to remove us from the current sizer, before we replace
  // it. Otherwise we get severe memory corruption, and crashes later
  // on. Once, even GDB and the Linux kernel started crashing,
  // although that should not be possible. But when we remove us
  // first, everyting works fine.
  if(m_wc->main_panel->GetSizer())
  {
    m_wc->main_panel->GetSizer()->Remove(this);
  }
}

void HtmlPanel::OnButton(wxCommandEvent &event) throw()
try
{
  GetTopWindow()->DoSoon(m_cp);
}
catch(Exception &ex)
{
  if(!ex.Close())
    abort();
}

BEGIN_EVENT_TABLE(HtmlPanel, wxPanel)
  EVT_BUTTON  (HTMLPANEL_BUTTON,    HtmlPanel::OnButton)
END_EVENT_TABLE()
