// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <wx/log.h>

#include <new>


#include "application.h"
#include "htmlpanel.h"
#include "introwc.h"

void IntroWC::Init(const wxExpr *ex, wxPanel *panel) throw(Exception)
try
{
  wxLogTrace("entering", "IntroWC::Init(expr, panel)");
  WindowContents::Init(ex, panel);

  wxString html_file, button_text, button_help;
  try
  {
    GetLocalizedAttribute(expr, "html_file", html_file); 
    GetLocalizedAttribute(expr, "button_text", button_text);
    GetLocalizedAttribute(expr, "button_help", button_help);
    html_file = from_utf8(html_file);
    button_text = from_utf8(button_text);
    button_help = from_utf8(button_help);
  }
  catch(Exception &ex)
  {
    throw NoisyException("Malformed item in room list: this "
			 "module requires the attributes "
			 "\"html_file\", \"button_text\" and "
			 "\"button_help\".");
  }

  try
  {
    html_file = GetApp()->config->GetModuleDataFile(html_file);
  }
  catch(...)
  {
    wxLogDebug("Could not find the HTML file, the HtmlPanel will complain...");
  }
  new HtmlPanel(this, html_file, button_text, button_help, m_pc);
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}
  
void IntroWC::PanelCreator::operator()() throw()
try
{
  m_iwc->main_panel->DestroyChildren();

  m_iwc->EnterRoom();
}
catch(Exception &ex)
{
  if(!ex.Close())
    abort();
}
