// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef INTROWC_H
#define INTROWC_H

// The (abstract) IntroWC class is for those classes that display some
// intro message and then go on. Derived classes should override the
// EnterRoom() method, which is called when the intro panel (managed
// entirely by IntroWC; currently we use HtmlPanel for this) says it's
// time to enter the room for real.

#include "windowcontents.h"
#include "command_processor.h"

class EXPORT IntroWC: public WindowContents
{
public:
  IntroWC() throw(): m_pc(this) {}
  
  void Init(const wxExpr *ex, wxPanel *panel) throw(Exception);
  
  virtual void EnterRoom() throw(Exception) = 0;
  
private:
  class EXPORT PanelCreator: public CommandProcessor
  {
  public:
    PanelCreator(IntroWC *iwc) throw(): m_iwc(iwc) {}
    
    virtual void operator()() throw();
    
  private:
    IntroWC *m_iwc;
  };

  PanelCreator m_pc;
};


#endif // INTROWC_H
