// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <wx/textctrl.h>
#include <wx/string.h>
#include <wx/event.h>
#include <wx/log.h>

#include <config.h>
#include "../checksetup.h"

#include "selfcorr.h"

int SelfCorrecting::ms_number = 0;

SelfCorrecting::SelfCorrecting(MultSim *ms, wxWindow *parent,
			       const wxString &answer) throw():
  m_answer(answer),
  m_ms(ms),
  wxTextCtrl(parent, -1, wxEmptyString, wxDefaultPosition,
	     wxDefaultSize, wxTE_RIGHT)
{
  Connect(GetId(), wxEVT_COMMAND_TEXT_UPDATED,
	  (wxObjectEventFunction) (wxEventFunction)
	  (wxCommandEventFunction) &SelfCorrecting::OnCorrect);

  if(! ms_number++)		// Ensures that the first one gets focus.
  {
    SetFocus();
  }
}

SelfCorrecting::~SelfCorrecting() throw()
{
  Disconnect(GetId(), wxEVT_COMMAND_TEXT_UPDATED,
	     (wxObjectEventFunction) (wxEventFunction)
	     (wxCommandEventFunction) &SelfCorrecting::OnCorrect);

  --ms_number;
}

wxString SelfCorrecting::GetValue() const
{
  if(wxTextCtrl::GetValue() == m_answer + _(": correct"))
    return m_answer;
  else
    return wxTextCtrl::GetValue();
}

void SelfCorrecting::OnCorrect(wxCommandEvent &ev)
{
  if(wxTextCtrl::GetValue() == m_answer)
  {
    SetEditable(false);
    SetValue(m_answer + _(": correct"));
  }
  else if(wxTextCtrl::GetValue() == m_answer + _(": correct"))
  {
    SetEditable(false);
    m_ms->OneMoreCorrect();
  }
}

