// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef ROOMGUARD_DATACONTROL_H
#define ROOMGUARD_DATACONTROL_H

#include <wx/wxexpr.h>
#include <new>

#include <config.h>
#include "checksetup.h"

#include "exceptions.h"
#include "module.h"
#include "roomguard.h"

class RGDataControl: public RoomGuard
{
public:
  RGDataControl();
  ~RGDataControl();

  static RGDataControl *current;

  void AddLabelledData(const wxString &label, wxExpr *value)
    throw(Exception);

  wxExpr* cGetData(const wxString &label)
    throw(Exception);

  void ForgetData(const wxString &label) throw();
  // make a copy of any data you intend to keep from GetData(), since
  // someone might call ForgetData() and remove what you're pointing to.

  // Called when there is a new room to be instantiated. You may
  // change the room by changing new_room.
  virtual void Replace(wxExpr *new_room) throw(Exception);

  virtual void Init(const wxExpr *expr) throw(Exception);
  virtual wxExpr* cHibernate() throw(Exception);

private:
  WX_DECLARE_STRING_HASH_MAP(wxExpr*, ExprHash);
  ExprHash m_hash;
};


#endif // ROOMGUARD_DATACONTROL_H

// 
// Local Variables:
// mode: c++
// End:
