// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/wx.h>

#include <config.h>
#include "../checksetup.h"

#include "../application.h"
#include "tgdialogue.h"

extern "C" char *version(void)
{
  return PACKAGE_STRING;
}

extern "C" char *type(void)
{
  return "TimeGuard";	// This is a TimeGuard object
}

void TGDialogue::Init(const wxExpr *expr) throw(Exception)
try
{
  TimeGuard::Init(expr);
  wxLogDebug("Entering TGDialogue::Init()");

  if(! m_expr->GetAttributeValue("minutes", m_minutes))
    throw NoisyException(_("The \"TGDialogue\" module requires "
			   "the attribute \"minutes\" (an integer)."));
  
  try
  {
    GetLocalizedAttribute(m_expr, "title", m_title);
    GetLocalizedAttribute(m_expr, "text", m_text);
    m_title = from_utf8(m_title);
    m_text = from_utf8(m_text);
  }
  catch(SilentException &ex)
  {
    throw NoisyException(_("The \"TGDialogue\" module requires "
			   "the attributes \"title\" and \"text\"."));
  }    
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

void TGDialogue::TimeLeft(int minutes) throw()
try
{
  wxLogDebug("TGDialogue::TimeLeft(minutes = %d); m_minutes = %d", minutes, m_minutes);
  if(minutes == m_minutes)
  {
    wxMessageBox(m_text, m_title, wxOK, GetTopWindow());
  }
}
catch(...)
{

}

// The class factories

extern "C" TimeGuard* create(void)
{
  wxLogDebug("Creating an TGDialogue object.");
  return new(std::nothrow) TGDialogue();
}

extern "C" void destroy(TimeGuard *w)
{
  wxLogDebug("Deleting a TimeGuard object (i.e. an TGDialogue object)");
  delete w;
}
