// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef TGDIALOGUE_H
#define TGDIALOGUE_H

#include <wx/wxexpr.h>

#include <config.h>
#include "../checksetup.h"

#include "../exceptions.h"
#include "../timeguard.h"

class TGDialogue: public TimeGuard
{
public:
  TGDialogue(): m_minutes(-1), m_title(wxEmptyString), m_text(wxEmptyString) {}

  virtual void Init(const wxExpr *expr) throw(Exception);

  virtual void TimeLeft(int minutes) throw();
private:
  int m_minutes;
  wxString m_title;
  wxString m_text;
};

#endif // TGDIALOGUE_H

// 
// Local Variables:
// mode: c++
// End:
