// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef TIMEGUARD_TIMEOUT_H
#define TIMEGUARD_TIMEOUT_H

#include <wx/string.h>

#include <config.h>
#include "checksetup.h"

#include "timeguard.h"

// IMPORTANT: in  all communication with  the time guards the  unit of
// time is a minute (in the  case of a timer, it's a millisecond!). In
// all cases, the time integer is the remaining time.

class TimeOut: public TimeGuard
{
public:
  TimeOut(const wxString &timeout): m_timeout(timeout) {}

  void TimeLeft(int t) throw();

  virtual wxExpr* cHibernate() throw(Exception) 
  { throw NullException("TimeOut has no wxExpr"); }


private:
  wxString m_timeout;
};


#endif // TIMEGUARD_TIMEOUT_H

// 
// Local Variables:
// mode: c++
// End:
