// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef COMMAND_PROCESSOR_H
#define COMMAND_PROCESSOR_H

#include <config.h>
#include "checksetup.h"

#include "windowcontents.h"

//// CommandProcessors

class CommandProcessor
{
public:
  virtual void operator()() throw() = 0;
};


// Automatically convert callback functions into CommandProcessor objects.

class Function: public CommandProcessor
{
public:
  typedef void command_processor_t(); // throw()

  Function(command_processor_t *cp): m_cp(cp) {}
  
  virtual void operator()() throw() { m_cp(); }

private:
  command_processor_t *m_cp;
};


// GoThrough the specified door
class EXPORT GoThroughDoor: public CommandProcessor
{
public:
  GoThroughDoor(WindowContents *wc, const wxString &door):
    m_wc(wc), m_door(door) {wxASSERT(wc != 0);}

  virtual void operator()() throw();

private:
  WindowContents *m_wc;
  wxString m_door;
};

#endif // COMMAND_PROCESSOR_H

// 
// Local Variables:
// mode: c++
// End:
