// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef ONE_H
#define ONE_H

#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/panel.h>

#include <config.h>
#include "../checksetup.h"

namespace One
{
  class One;
}

#include "../application.h"
#include "../introwc.h"
#include "../theme.h"
#include "onepanel.h"
#include "onedata.h"

// The *One classes are WindowContents classes that display an image
// and presents the user with some choices or some other means of
// answering. Normally the image would contain a question of some
// sort.
//
// It needs to have a data file, saying what images to display
// and what choices/answers are available.

namespace One
{
  class EXPORT Restarter: public CommandProcessor
  {
  public:
    Restarter(One *one) throw(): m_one(one) {}

    void operator()() throw();
  private:
    One* m_one;
  };



class EXPORT One: public IntroWC
{
public:
  One() throw(): m_panel(NULL), m_data(NULL), m_restarter(this) {}

  virtual void Init(const wxExpr *expr,
		    wxPanel *panel) throw(Exception);

  virtual void EnterRoom() throw(Exception) = 0;

  virtual void Destroy() throw();

  void ReloadPanel() throw();

  virtual wxExpr* cHibernate() throw(Exception);

  friend class OnePanel;
protected:
  OnePanel *m_panel;
  OneData *m_data;
  wxString m_filename;


public:
  ::One::Restarter m_restarter;

private:
  Theme *m_theme;
};

}

#endif // ONE_H

// 
// Local Variables:
// mode: c++
// End:
