// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <wx/log.h>
#include <wx/image.h>

#include <new>

#include <config.h>
#include "../checksetup.h"

#include "chooseonedata.h"

bool myErrorHandler(int err, char *msg)
{
  if(err == WXEXPR_ERROR_SYNTAX)
  {
    wxLogError(_("Syntax error in ChooseOne file: %s"), msg);
  }
  else
  {
    wxLogError(_("Error while processing ChooseOne file: %s"), msg);
  }
  return true;			// Continue anyway
}


ChooseOneData::ChooseOneData(const wxString &filename, ChooseOne *co)
  throw(Exception) try:
  OneData(filename, co)
{
  wxLogTrace("One", "Constructing ChooseOneData");
  wxASSERT(co != NULL);
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

ChooseOneData::~ChooseOneData() throw()
{
  wxLogTrace("One", "Destructing ChooseOneData");
}

void ChooseOneData::SetSelection(int selection) throw(Exception)
{
  wxLogTrace("ChooseOne", "ChooseOne::SetSelection(%d)", selection);

  wxASSERT(this != NULL);
  wxASSERT(m_db != NULL);

  m_db->BeginFind();
  wxExpr *e_screen = m_db->FindClauseByFunctor(m_current_screen);

  if(e_screen == NULL)
    throw NoisyException(wxString::Format
			 (_("Error in ChooseOne file. Could not retrieve "
			   "the clause named \"%s\"."),
			  m_current_screen.c_str()));

  wxASSERT('A' + selection <= 'Z');

  e_screen->GetAttributeValue(wxString(static_cast<char>('A'+selection)) + "_goto",
			      m_current_screen);

  wxLogTrace("ChooseOne", "The current screen is now \"%s\"", m_current_screen.c_str());
  
  m_db->BeginFind();
  if(m_db->FindClauseByFunctor(m_current_screen) == NULL)
  {
    m_one->GoThroughDoor(m_current_screen);
    throw SilentException("Just relax, don't do anything, everything is under control.");
  }
}

void ChooseOneData::AddAnswersToScreen(wxExpr *e_screen, One::Screen *oscreen)
{
  wxASSERT(e_screen != NULL);
  wxASSERT(oscreen != NULL);

  Screen *screen = dynamic_cast<Screen*>(oscreen);
  wxASSERT(screen != NULL);

  int number_of_choices = 0;
  e_screen->GetAttributeValue("number", number_of_choices);
  wxLogTrace("ChooseOne", "There seem to be %d choiches here.", number_of_choices);

  wxString choice;
  wxASSERT('A' + number_of_choices - 1 <= 'Z');
  // Note that there might not be any choices in the resulting Screen object.
  if(number_of_choices != 0)
  {
    for(char i = 0; i < number_of_choices; i++)
    {
      choice = wxEmptyString;
      e_screen->GetAttributeValue(wxString(static_cast<char>('A'+i)), choice);
      wxLogTrace("ChooseOne", "Got choice %s.", choice.c_str());
      screen->choices.push_back(from_utf8(choice));
    }
  }
}


void ChooseOneData::SaveData(const wxString &title) const throw()
try
{
  // FIXME

//   wxExpr *el = new wxExpr(wxExprList);

//   for(list<SelfCorrecting*>::iterator iter = m_sc.begin();
//       iter != m_sc.end();
//       ++iter)
//   {
//     if(*iter != NULL)
//     {
//       el->Append(new wxExpr(wxExprString, (*iter)->GetValue()));
//     }
//     else
//     {
//       el->Append(new wxExpr(wxExprString, ""));
//     }
//   }

//   // AddLabelledData() makes a local copy.
//   GetApp()->AddLabelledData(title, el);

//   delete el;
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}


// void ChooseOnePanel::LoadData() throw()
// try
// {
//   wxExpr *el = GetApp()->cGetData(m_ms->expr->Functor() + "_data");

//   if(el->Type() == wxExprList)
//   {
//     wxExpr *item = el->GetFirst();
//     list<SelfCorrecting*>::iterator iter = m_sc.begin();
//     for(; item != NULL && iter != m_sc.end(); (item = item->GetNext()), ++iter)
//     {
//       if(item->Type() == wxExprString)
//       {
// 	if(*iter != NULL)
// 	{
// 	  (*iter)->SetValue(item->StringValue());
// 	}
//       }
//     }
//   }

//   delete el;

//   // If there was any data, it was probably in a file the user had
//   // saved, and should not be used again during this session.
//   GetApp()->ForgetData(m_ms->expr->Functor() + "_data");
// }
// catch(NullException &ex)
// {
//   wxLogDebug("There is no saved data for this object.");
// }
