// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef SELFCORR_H
#define SELFCORR_H

#include <wx/textctrl.h>
#include <wx/string.h>

#include <config.h>
#include "../checksetup.h"

class SelfCorrecting;

#include "multsim.h"

class SelfCorrecting: public wxTextCtrl
{
public:
  SelfCorrecting(MultSim *ms, wxWindow *parent, const wxString &answer) throw();
  ~SelfCorrecting() throw();

  void OnKillFocus(wxFocusEvent &ev);
  void OnTextEnter(wxCommandEvent &ev);

  void Correct() throw();

  wxString GetValue() const;

private:
  static int ms_number;
  wxString m_answer;
  MultSim *m_ms;
};

#include "multsim.h"

#endif // SELFCORR_H

// 
// Local Variables:
// mode: c++
// End:
