// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef CHOOSEONEDATA_H
#define CHOOSEONEDATA_H

#include <wx/object.h>
#include <wx/bitmap.h>
#include <wx/wxexpr.h>
#include <wx/panel.h>

#include <vector>
using namespace std;

#include <config.h>
#include "../checksetup.h"

class ChooseOneData;

#include "../application.h"
#include "../introwc.h"
#include "../theme.h"
#include "../one/onedata.h"
#include "chooseone.h"
#include "chooseonepanel.h"

// The CooseOneData class is for the ChooseOne what the RoomList is
// for the Application.

// The Screen struct is the struct used for communication with the
// ChooseOnePanel.

struct Screen: public One::Screen
{
  vector<wxString> choices;

  typedef vector<wxString>::iterator choice_iterator;
};

class ChooseOneData: public One::OneData
{
public:
  ChooseOneData(const wxString &filename, ChooseOne *co) throw(Exception);
  virtual ~ChooseOneData() throw();

  void SetSelection(int selection) throw(Exception);
  Screen *cGetScreen() throw(Exception);
protected:
  virtual void AddAnswersToScreen(wxExpr *e_screen, One::Screen *screen);
  virtual Screen *cScreen() throw(Exception) try { return new Screen; }
            catch(std::bad_alloc &exception) { throw NoisyBadAlloc(); }


public:
  void SaveData(const wxString &title) const throw();
};

#endif // CHOOSEONEDATA_H

// 
// Local Variables:
// mode: c++
// End:
