// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef TIMEGUARD_H
#define TIMEGUARD_H

#include <wx/timer.h>
#include <wx/wxexpr.h>
#include <new>

#include <config.h>
#include "checksetup.h"

#include "exceptions.h"
#include "module.h"

// IMPORTANT: in  all communication with  the time guards the  unit of
// time is a minute (in the  case of a timer, it's a millisecond!). In
// all cases, the time integer is the remaining time.

class TimeGuard
{
public:
  TimeGuard(): m_module(NULL), m_expr(NULL) {}
  virtual ~TimeGuard() { if(m_expr != NULL) delete m_expr; }

  // If the TimeGuard HasModule(), the module should be deleted when
  // the time guard is to be destroyed. The module will take care of
  // TimeGuard destruction.
  bool HasModule() { return (m_module != NULL); }
  Module<TimeGuard> *GetModule() { return m_module; }
  void SetModule(Module<TimeGuard> *module) { m_module = module; }

  virtual void Init(const wxExpr *expr) throw(Exception)
  try { wxASSERT(m_expr == NULL); m_expr = expr->Copy(); }
  catch(std::bad_alloc &ex) { throw NoisyBadAlloc(); }

  virtual void TimeLeft(int t) throw() = 0;

  virtual wxExpr* cHibernate() throw(Exception) 
  try { return m_expr->Copy(); }
  catch(std::bad_alloc &ex) { throw NoisyBadAlloc(); }

protected:
  const wxExpr *m_expr;

private:
  Module<TimeGuard> *m_module;
};


#endif // TIMEGUARD_H

// 
// Local Variables:
// mode: c++
// End:
