#    mdf - "My download manager Downloads Fabulously" - is a simple command line download manager written in perl
 
#    Copyright (C) 2005  Tjaart van der Walt
 
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
 
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
#    email: rkwtavdw@puk.ac.za

#! /usr/bin/perl
use Getopt::Long;
use Net::FTP;
use IO::Socket::INET;
# Options followed by a : requires a parameter
#getopts('avhu:p:');

# Define command line variables 
my $verbose = "";
my $help = "";
my $ascii = "";
my $binary = "";
my $user = "anonymous";
my $pass = 'anonymous@';
my $proxy_user = "";
my $proxy_pass = "";
my $start = "";
my $stop = "";
my $block_size = "10240";
my $fw = "";
my $fw_type = 1;
my $VERSION = 0.01;
$result = GetOptions ("help" => \$help,"verbose"  => \$verbose , "ascii"  => \$ascii , "binary"  => \$binary , "user=s" =>\$user , "pass=s" =>\$pass, "proxy_user=s" =>\$proxy_user, "proxy_pass=s" =>\$proxy_pass, "start=s" =>\$start, "stop=s" =>\$stop , "block=i" =>\$block_size, "fw_type=i" =>\$fw_type, "fw_type=s" =>\$fw, "version" =>\$get_VERSION );

# If no parameters are given...show the help
if($ARGV[0] eq "" and !$get_VERSION)
{
	$help=1;
}
# Prints out the help options and exit
if($help)
{
print("\n");
print("My Download manager is a simple command line download manager written in perl.\n\n");
print("Usage: mdman [OPTIONS] URL\n");
print("\n");
print("[OPTIONS]\n\n");
print("--user       Specify a FTP username (default anonymous)\n");
print('--pass       Specify a FTP username (default anonymous@anonymous.com)'."\n");
print("--proxy_user Specify a proxy username \n");
print("--proxy_pass Specify a proxy password\n");
print("--fw         Specify the firewall host\n");
print("--fw_type    Specify a Firewall type (See readme for supported types)\n");
print("--start      Specify a starting time for the download\n");
print("--stop       Specify a stopping time for the download\n");
print("--block      Specify a block size in bytes (default 10240)\n");
print("--verbose    Verbose mode\n");
print("--version    Displays the version number and exits\n");
print("--help       Displays this message and exits\n");
print("\n");
print("URL          Gives the URL of the file that is to be downloaded\n\n");

print('Report bugs to <rkwtavdw@puk.ac.za>'."\n");
print("\n");
exit;
}
if($get_VERSION)
{
	print "MDF Version $VERSION\n";
	print "Copyright (C) 2005 Tjaart van der Walt.\n";
	print "This is free software; see the source for copying conditions.  There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n";

	
	exit;
}
($protokol,$path)= split("://",$ARGV[0]);

@units = split("/",$path);

$host = shift @units;

for $i ( 0 .. $#units-1){
	$dir.= "/".shift @units;
}

$file = $units[0];

#if($ARGV[1] ne "") {$file = $ARGV[1]} else {$file = $file}


if($protokol ne "ftp")
{
	print "Error: The protocol you specified is not supported. Currently only ftp is supported.\n";
	exit;
}



if($verbose){print "Using protocol: $protokol\n"};

if($protokol eq "ftp")
{
#$options{Firewall}=$fw;
#$options{FirewallType}=$fw_type;

	$ftp = Net::FTP->new("$host",@options) or $die=1;
	
	if($die==1)
	{
		print "Could not connect to: $host\n";
		exit;
	}
	if($verbose){print "Connected to: $host\n";}

	# Login to FTP site
	$ftp->login("$user","$pass") or die "Cannot login: ", $ftp->message;
	
	$ftp -> cwd($dir) or die "Cannot execute command: ", $ftp->message;;
	
	if($verbose){print "Changing to directory: $dir\n";}

	if($verbose){print "Using buffer size: $block_size\n"};
	
	# Set the default file transfer type
	$ftp -> binary;

	
	
	# If it is a resumed file, read the config file
	if(stat("$file.mdf") != null)
	{
		open(CONFIG,"<$file.mdf") or die;
		while(<CONFIG>){($key,$value) = split;$config{$key}=$value;}
		close(CONFIG); 
	}
	else {$config = null;}
	

	# If delayed start is set wait till starting time
	if($start ne "")
	{
		sleep time_left($start);
	}
	
	# Gets the file size from the server
	$file_size = $ftp -> size($file);

	# If the file is resumed
	if($config{size_downloaded} != null)
	{
		# Checks whether the file downloaded and the file on the server has the same size
		if( $file_size != $config{file_size}){print "Sorry the file cannot be continued!";exit;} 
		# Set the offset of the file
		$size_downloaded = $config{size_downloaded};
		if($verbose){print "Resuming file at byte: $size_downloaded\n"};
		
		# Appends file
		open(FILE_TEMP,">>$file.tmp") or die("can't open datafile: $!");
		binmode(FILE_TEMP);
	}
	# If no file exists
	else
	{
		# Opens a new file
		open(FILE_TEMP,">$file.tmp") or die("can't open datafile: $!");
		binmode(FILE_TEMP);
		# Bytes downloaded = 0
		$size_downloaded = 0;
	}
		
	# Sets the offset of the file
	$ftp -> restart($size_downloaded);
	# Start retrieving the file
	$res = $ftp -> retr($file);
	
	
	print "Download complete: 0% ";
	
	
	# As long as the downloaded part is smaller than the filesize continue downloading
	while($downloaded < $file_size)
	{
		# Read the next $block bytes (Default block size for ftp 10240 bytes )
		$res -> read($buffer,$block_size);
		#print $buffer;
		# Write the read bytes to the file
		print FILE_TEMP $buffer;
		$downloaded = $res -> bytes_read()+$size_downloaded;
		print "\b\b\b";
		print sprintf("%02d%%",$downloaded/$file_size*100);
		if($stop ne "")
		{
			if(time_left($stop)==0)
			{
				open(CONFIG,">$file.mdf") or $die=1;
				print CONFIG "url $ARGV[0]\n";
				print CONFIG "file_size $file_size\n";
				print CONFIG "size_downloaded $downloaded\n";
				close CONFIG;
				print "\nDownload stopped.";
				exit;
			}
		}
	}
	if($die==1)
	{
		print "Could not find file: $file\n";
		exit;
	}
	close FILE_TEMP;
	unlink "$file.mdf";
	rename "$file.tmp","$file";
	print "\n";
}

sub time_left
{
	use HTTP::Date;
	use Time::localtime;

	$time_now = time();
	$year = (localtime->year()+1900);
	$month = sprintf("%02d",localtime->mon()+1);
	$day = sprintf("%02d", localtime->mday());
	$date = "$year-$month-$day";
	$start_time = str2time("$date $_[0]:00");

	# If the time has already passed for today, schedule download for tomorrow
	if($start_time < $time_now)
	{
		$day = sprintf("%02d", localtime->mday()+1);
		$date = "$year-$month-$day";
		$start_time = str2time("$date $_[0]:00");
	}
	return $start_time - $time_now;
}
