#!/bin/bash
#set -x
set -e
exec 2>&1

SERV="mdtx"
COLL="dropit"
COLLECTION="$SERV-$COLL"
CAT_FILE="/etc/mediatex/$COLLECTION/catalogNN.txt"
PWD_FILE="/etc/mediatex/$COLLECTION/apache2/htpasswd"
GRP_FILE="/etc/mediatex/$COLLECTION/apache2/htgroup"

function Usage()
{
    echo -e "$0 (user|dir|file) PARAMETER{2|3}"
    echo -e "\twith parameters:"
    echo -e "\t\tuser:\tLOGIN\tPASSWD"
    echo -e "\t\tdir:\tNAME\tFATHER"
    echo -e "\t\tfile:\tNAME\tFATHER\tTEMP"
}

function addUser()
{
    LOGIN=$1
    PASSWD=$2

    CYPHER=$(printf "$LOGIN:$COLLECTION:$PASSWD" | md5sum | cut -d' ' -f1)
    LINE="$LOGIN:$COLLECTION:$CYPHER"
    echo $LINE >> $PWD_FILE
    sed $GRP_FILE -i -e "s/^\(.*\)$/\1 $LOGIN/"

cat >>$CAT_FILE <<EOF
Human    "$LOGIN" ""
EOF
}

function addDir()
{
    NAME=$1
    FATHER=$2

    cat >>$CAT_FILE <<EOF
top Category "$NAME": "$FATHER"
EOF
    mediatex upgrade coll $COLL
}

function addFile()
{
    LOGIN=$1
    NAME=$2
    FATHER=$3
    TEMP=$4

    HASH=$(md5sum $TEMP | cut -d' ' -f1)
    SIZE=$(ls -l $TEMP | awk '{print $5}')

    mediatex upload $TEMP to coll $COLL

    cat >>$CAT_FILE <<EOF
Document "$NAME": "$FATHER"
  with "uploader" = "$LOGIN" ""
  $HASH:$SIZE
EOF
    mediatex upgrade coll $COLL
}


case $1 in
    user)
	addUser $2 $3;;
    dir)
	addDir $2 $3;;
    file)
	addFile $2 $3 $4 $5;;
    *)
	Usage $@
	exit 1
esac
