#!/usr/bin/perl
#=======================================================================
# * Version: $Id$
# * Project: MediaTex
# * Module : Reversibility use case
# *
# * This cgi-script provide a multiple entry form 
#
# MediaTex is an Electronic Records Management System
# Copyright (C) 2014 2015 Nicolas Roche
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#=======================================================================

use CGI;
use DBI;

$html = new CGI;
print $html->header;

my %hash = ();
$limit = 10;
$label=$html->param('label');
$page = $html->param('page');
$debug=0;

#########################################################################
$uri="search.cgi";
$filename = '/tmp/txt2sql/credentials.sh';
#print "credentials -> $filename<br>\n";
 
if (!open($fh, $filename)) {
    print "Cannot open file: $filename<BR>\n";
    exit;
}

while (my $row = <$fh>) {
    $row =~ /(.*)=(.*)$/;
    $key = $1;
    $value = $2;

    if ($key eq 'DB_BASE') {
	$dbname = $value;
    }
    if ($key eq 'DB_HOST') {
	$dbhost = $value;
    }
    if ($key eq 'DB_PORT') {
	$dbport = $value;
    }
    if ($key eq 'DB_USER') {
	$dbuser = $value;
    }
    if ($key eq 'DB_PASSWD') {
	$dbpasswd = $value;
    }
    if ($key eq 'VIEW_PRE') {
	$prefix = $value."_";
    }

    #print "$row : $key -> $value\n<br>";
}

if (!(defined($dbname))) {
    $msg = "No DB_NAME";
}
if (!(defined($dbhost))) {
    $msg = "No DB_HOST";
}
if (!(defined($dbport))) {
    $msg = "No DB_PORT";
}
if (!(defined($dbuser))) {
    $msg = "No DB_USER";
}
if (!(defined($dbpasswd))) {
    $msg = "No DB_PASSWD";
}
if (!(defined($prefix))) {
    $msg = "No DB_PREFIX";
}
if (defined($msg)) {
    print "Configuration error: $msg<BR>\n";
    exit;
}
#########################################################################

# table name without "s" as paramter
sub formCaracs{
    my @array;

    $query="SELECT distinct carac FROM ".$_[0]."_caracs";
    $cursor = $dbh->prepare($query); 
    $cursor->execute;

    while ( @row = $cursor->fetchrow ) {
	print "<TR>\n";
	print "<TD>$row[0]</TD>";
	$val=$html->param($row[0]);

	$query="SELECT DISTINCT value FROM ".$_[0]."_caracs ".
	    "WHERE carac = '".$row[0]."' ORDER BY value ASC";
	$cursorLst = $dbh->prepare($query);
	$cursorLst->execute;

	print "<TD><SELECT NAME='$row[0]' VALUE='$val'>\n";
	print "<OPTION>\n";
	while ( @rowLst = $cursorLst->fetchrow ) {
	    if ($rowLst[0] eq $val) {
		print "<OPTION selected>$rowLst[0]\n";
	    }
	    else {
		print "<OPTION>$rowLst[0]\n";
	    }
	}
	print "</SELECT></TD>\n";
	print "</TR>\n";

	# backup carac's label
	push(@array, $row[0]);
    }
    $hash{$_[0]} = [ @array ];
}

# table name without "s" as paramter
sub selectCaracs{
    @array = @{ $hash{$_[0]} };
    $char = substr($_[0], length($prefix), 1);
    for ($i = 0; $i <= $#array; ++$i) {
	$select=$select.", ".$char."c".$i.".value";
    }
}

# table name without "s" as paramter
sub fromCaracs{
    @array = @{ $hash{$_[0]} };
    $char = substr($_[0], length($prefix), 1);
    for ($i = 0; $i <= $#array; ++$i) {

	# left join
	$query=$query." left join ".$_[0]."_caracs as ".$char."c".$i;

	# ids
	if ($char eq 'd') {
	    $query=$query." ON doc.label = ".$char."c".$i.".document";
	    $query=$query." AND doc.coll = ".$char."c".$i.".coll";
	}
	if ($char eq 'a') {
	    $query=$query." ON arc.hash = ".$char."c".$i.".hash";
	    $query=$query." AND arc.size = ".$char."c".$i.".size";
	    $query=$query." AND arc.coll = ".$char."c".$i.".coll";
	}

	# search field
	$query=$query." AND ".$char."c".$i.".carac = '".$array[$i]."'";
    }
}

# table name without "s" as paramter
sub whereCaracs{
    @array = @{ $hash{$_[0]} };
    $char = substr($_[0], length($prefix), 1);
    for ($i = 0; $i <= $#array; ++$i) {
	$val=$html->param($array[$i]);
	
	# search value
	if (!($val eq '')) {
	    $query=$query." AND ".$char."c".$i.".value = '".$val."'";
	}
    }
}

# table name without "s" as paramter
sub orderCaracs{
    @array = @{ $hash{$_[0]} };
    $char = substr($_[0], length($prefix), 1);
    for ($i = 0; $i <= $#array; ++$i) {
	$select=$select.", ".$char."c".$i.".value";
    }
}

# table name without "s" as paramter
sub showHeadCaracs{
    @array = @{ $hash{$_[0]} };
    for ($i = 0; $i <= $#array; ++$i) {
	print "<TD>".$array[$i]."</TD>";
    }
}

# table name without "s" as paramter
sub showCaracs{
    @array = @{ $hash{$_[0]} };
    for ($i = 0; $i <= $#array; ++$i) {
	printf "<TD>%s</TD>", $row[++$j];
    }
}

# display page counter
sub showPages{
    print "<P>pages : ";
    $url= $html->self_url(-relative=>1);
    if ($page > 0) {
	$p = $page - 1;
	$url =~ s/page=.*/page=$p/;
	printf "<A href='%s'><</A>", $url;
    }
    else {
	print "<";
    }
    printf " %i/%i ", $page, $nb/$limit;
    $url= $html->self_url(-relative=>1);
    if ($page < int($nb/$limit)) {
	$p = $page + 1;
	$url =~ s/page=.*/page=$p/;
	printf "<A href='%s'>></A>", $url;
    }
    else {
	print ">";
    }
    print "</P>";
}

# connect DB
if (!($dbh = DBI->connect(
    "dbi:Pg:dbname=$dbname;host=$dbhost;port=$dbport", $dbuser, $dbpasswd
    ))) {
    printf "Database error: ".$DBI::errstr;
    exit;
}

# display formulary
print "<FORM ACTION='$uri' METHOD='GET'>\n";
print "<TABLE></HR>\n";
print "<TR><TD><HR></TD><TD><HR></TD></TR>\n";
print "<TR><TD>label</TD><TD><INPUT NAME='label' VALUE='".$label."'></TD></TR>\n";
formCaracs($prefix."document");
print "<TR><TD><HR></TD><TD><HR></TD></TR>\n";
formCaracs($prefix."archive");
print "<TR><TD></TD><TD><INPUT HIDDEN NAME='page' VALUE='0'></TD></TR>\n";
print "<TR><TD><HR></TD><TD><HR></TD></TR>\n";
print "<TR><TD><INPUT TYPE=submit VALUE='Chercher'></TD>\n";
print "<TD><INPUT TYPE='button' VALUE='Annuler' ".
    "onclick='location.href=\"index.shtml\"'></TD></TR>\n";
print "<TR><TD><HR></TD><TD><HR></TD></TR>\n";
print "</TABLE>\n";
print "</FORM>\n";

if (defined($page)) {
    # build queries
    $query='';
    $count="SELECT count(*)";
    $select="SELECT doc.label, doc.coll, doc.url, arc.url";
    selectCaracs($prefix."document");
    selectCaracs($prefix."archive");

    # common part
    $query=$query.
	" FROM ".$prefix."documents as doc";
    fromCaracs($prefix."document");
    $query=$query.
	", ".$prefix."archives as arc";
    fromCaracs($prefix."archive");
    $query=$query.
	", ".$prefix."document_archives as da";
    $query=$query.
	" WHERE doc.label = da.label".
	" AND arc.hash = da.hash".
	" AND arc.size = da.size".
	" AND doc.coll = da.coll".
	" AND arc.coll = da.coll";
    if (!($label eq '')) {
	$query=$query." AND doc.label ILIKE '%".$label."%'";
    }
    whereCaracs($prefix."document");
    whereCaracs($prefix."archive");

    # assembling queries
    $count=$count.$query;
    $select=$select.$query." ORDER BY doc.label";
    orderCaracs($prefix."document");
    orderCaracs($prefix."archive");
    $select=$select." ASC LIMIT ".$limit." OFFSET ".$page*$limit;

    if ($debug == 1) {
	print "<PRE>".$count.";<BR>";
	print $select.";</PRE>";
    }

    # run count query
    $cursor = $dbh->prepare($count);
    $cursor->execute;
    @row = $cursor->fetchrow;
    $nb =  $row[0];

    # run select query
    $cursor = $dbh->prepare($select);
    $cursor->execute;

    # display results
    showPages();
    print "<TABLE BORDER=1>\n";
    print "<TR>\n";
    printf "<TD>label</TD><TD>coll</TD><TD>info</TD>";
    showHeadCaracs($prefix."document");
    showHeadCaracs($prefix."archive");
    print "</TR>\n";

    while ( @row = $cursor->fetchrow ) {
    	print "<TR>\n";
    	printf "<TD><A href='../%s'>%s</A></TD>", $row[3], $row[0];
	$row[1] =~ tr/_/-/;
	printf "<TD><A href='../~%s'>%s</A></TD>", $row[1], $row[1];
	printf "<TD><A href='../%s'>?</A></TD>\n", $row[2]; 
	$j=3;
	showCaracs($prefix."document");
	showCaracs($prefix."archive");
    	print "</TR>\n";
    }
    print "</TABLE>\n";

    $cursor->finish;
    $dbh->disconnect;
    showPages();
}

print "</BODY>\n";
print "</HTML>\n";
exit;
