#!/bin/sh
#set -x
#=======================================================================
# * Project: MediaTex
# * Module : scripts
# *
# * This script is call by cron
#
# MediaTex is an Electronic Records Management System
# Copyright (C) 2014 2015 2016 Nicolas Roche
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#=======================================================================

STATEDIR=/var/lib/mediatex
BINDIR=/usr/bin
CACHEDIR=/var/cache/mediatex
MDTX=${MDTX-mdtx}
GITCLT=$CACHEDIR/$MDTX/git

# backup git module
for COLL in $($BINDIR/mediatex -c $MDTX ls master coll); do
    DO_LOG=$(grep -i logGit $GITCLT/$MDTX-$COLL/servers.txt | \
		    awk '{ print $2 }')
    case $DO_LOG in
	yes|Yes|YES|y|Y|true|True|TRUE|t|T)
	    DATE=$(date +'%Y%m%d')
	    NAME=/tmp/git_$COLL_$DATE

	    tar -zcf $NAME.tgz $STATEDIR/$MDTX/$MDTX-$COLL 2>/dev/null
	    SIGN=$(md5sum $NAME.tgz | cut -d' ' -f 1)
	    SIGN=$SIGN:$(ls $NAME.tgz -l | cut -d' ' -f 5)

	    cat >$NAME.cat <<EOF
Top Category "~mediatex"
Category "backups": "~mediatex"

Document "git_$DATE": "backups"
 "uploaded from" = "$(hostname -f)"
 $SIGN
EOF

	    $BINDIR/mediatex -c $MDTX upload++ \
		file $NAME.tgz as mediatex/backups/ \
		catalog $NAME.cat \
		to coll $COLL
	    
	    rm -f $NAME.tgz $NAME.cat
	    ;;
    esac
done

