#!/bin/bash
#=======================================================================
# * Project: MediaTex
# * Module : script libs
# *
# * load mediatex path and variables
#
# MediaTex is an Electronic Records Management System
# Copyright (C) 2014 2015 2016 Nicolas Roche
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#=======================================================================
#set -x
set -e

# includes
MDTX_SH_INCLUDE=1
[ -z $srcdir ] && srcdir=.
[ -z $libdir ] && libdir=$srcdir/scripts/lib
[ ! -z $MDTX_SH_LOG ] || source $libdir/log.sh

# running variables from env (command.c)
UNIT_TEST_RUNNING=0
DRY_RUN=${MDTX_DRY_RUN-0}
MDTX=${MDTX_MDTXUSER-mdtx}

# /usr/bin/install do not honor default acl
# expect parameters likes :
#  -o OWNER -g GROUP -m MODE -d DIR
#  -o OWNER -g GROUP -m MODE SRC DEST
# $2 : OWNER
# $4 : GROUP
# $6 : MODE
# $7 : SRC or -d
# $8 : DST or DIR
function install()
{
    #Debug "$FUNCNAME: $*" 2

    DST=$8
    if [ $7 == "-d" ]; then
	mkdir -p $DST
    else
	if [ -d $8 ]; then
	    DST=$8/$(basename $7)
	fi
	cp $7 $DST
    fi
    chmod $6 $DST
    chown $2.$4 $DST
}

Debug "load $MDTX's paths"

# from automake (./configure)
MEDIATEX=/mediatex
BINDIR=/usr/bin
DATAROOTDIR=/usr/share
EXEC_PREFIX=/usr
LOCALSTATEDIR=/var
PREFIX=/usr
SYSCONFDIR=/etc

## copy/paste from mediatex.config
# note: values for unit tests are differents due to jails (utscripts.sh)

# path configuration variables for scripts
ETCDIR="${SYSCONFDIR}${MEDIATEX}"
DATADIR="${DATAROOTDIR}${MEDIATEX}"
STATEDIR="${LOCALSTATEDIR}/lib${MEDIATEX}"
CACHEDIR="${LOCALSTATEDIR}/cache${MEDIATEX}"
PIDDIR="${LOCALSTATEDIR}/run${MEDIATEX}"
SCRIPTS="${DATADIR}/scripts"
MISC="${DATADIR}/misc"
HOSTSSH="${SYSCONFDIR}/ssh"

# running variables from env (command.c)
DRY_RUN=${MDTX_DRY_RUN-0}
MDTX=${MDTX_MDTXUSER}

## copy/paste from src/mediatex-config.h

# relative paths
CONF_MD5SUMS="/md5sums"
CONF_CACHES="/cache"
CONF_EXTRACT="/tmp"
CONF_HOME="/home"
CONF_GITCLT="/git"
CONF_SSHDIR="/.ssh"
CONF_JAIL="/jail"
CONF_HTMLDIR="/public_html"
CONF_CONFFILE=".conf"
CONF_PIDFILE="d.pid"

# basenames
CONF_SUPPFILE="/supports.txt"
CONF_SERVFILE="/servers"
CONF_CATHFILE="/catalog"
CONF_EXTRFILE="/extract"
CONF_RSAUSERKEY="/id_rsa.pub"
CONF_DSAUSERKEY="/id_dsa.pub"
CONF_RSAHOSTKEY="/ssh_host_rsa_key.pub"
CONF_DSAHOSTKEY="/ssh_host_dsa_key.pub"
CONF_SSHKNOWN="/known_hosts"
CONF_SSHAUTH="/authorized_keys"
CONF_SSHCONF="/config"
CONF_COLLKEY="/aesKey.txt"
TESTING_PORT=6560
CONF_PORT=6561
SSH_PORT=22

# recurent variables
GITBARE="${STATEDIR}/$MDTX"
MDTXHOME="${CACHEDIR}/$MDTX"
MD5SUMS="${MDTXHOME}${CONF_MD5SUMS}"
CACHES="${MDTXHOME}${CONF_CACHES}"
EXTRACT="${MDTXHOME}${CONF_EXTRACT}"
GITCLT="${MDTXHOME}${CONF_GITCLT}"
JAIL="${MDTXHOME}${CONF_JAIL}"
HOMES="${MDTXHOME}${CONF_HOME}"
MDTXGIT="${GITCLT}/$MDTX"
CONFFILE="${MDTXGIT}/$MDTX${CONF_CONFFILE}"
PIDFILE="${PIDDIR}/$MDTX${CONF_PIDFILE}"

FALSE=1
TRUE=0

BASE_ACL="u::rwx g::rwx o::--- m:rwx"

_ETC_M=("root" "root"  0755 "NO ACL")
_VAR_RUN_M=("root" "root"  0777 "NO ACL")
_VAR_LIB_M=("root" "root"  0755 "NO ACL")
_VAR_LIB_M_MDTX=("root" "root"  0755 "NO ACL")
_VAR_LIB_M_MDTX_MDTX=("root" "root"  0750 "u:%s:rwx g:%s:rwx u:www-data:r-x")
_VAR_LIB_M_MDTX_COLL=("root" "root"  0750 "u:%s:rwx g:%s:rwx u:%s:rwx u:www-data:r-x")
_VAR_CACHE_M=("root" "root"  0755 "NO ACL")
_VAR_CACHE_M_MDTX=("root" "root"  0755 "NO ACL")
_VAR_CACHE_M_MDTX_CACHE=("root" "root"  0755 "NO ACL")
_VAR_CACHE_M_MDTX_CACHE_M=("root" "root"  0755 "NO ACL")
_VAR_CACHE_M_MDTX_CACHE_COLL=("root" "root"  0750 "u:%s:rwx g:%s:rwx u:%s:r-x u:www-data:r-x")
_VAR_CACHE_M_MDTX_HTML=("root" "root"  0750 "u:%s:rwx g:%s:rwx u:www-data:r-x")
_VAR_CACHE_M_MDTX_GIT=("root" "root"  0755 "NO ACL")
_VAR_CACHE_M_MDTX_GIT_MDTX=("root" "root"  0750 "u:%s:rwx g:%s:rwx u:www-data:r-x")
_VAR_CACHE_M_MDTX_GIT_COLL=("root" "root"  0750 "u:%s:rwx g:%s:rwx u:%s:rwx u:www-data:r-x")
_VAR_CACHE_M_MDTX_TMP=("root" "root"  0755 "NO ACL")
_VAR_CACHE_M_MDTX_TMP_COLL=("root" "root"  0750 "u:%s:rwx g:%s:rwx u:%s:rwx")
_VAR_CACHE_M_MDTX_HOME=("root" "root"  0755 "NO ACL")
_VAR_CACHE_M_MDTX_HOME_COLL=("root" "root"  0755 "NO ACL")
_VAR_CACHE_M_MDTX_HOME_COLL_SSH=("%s" "%s"  0700 "NO ACL")
_VAR_CACHE_M_MDTX_HOME_COLL_HTML=("root" "root"  0750 "u:%s:rwx g:%s:rwx u:%s:r-x u:www-data:r-x")
_VAR_CACHE_M_MDTX_HOME_COLL_VIEWVC=("root" "root"  0750 "u:%s:rwx g:%s:rwx u:%s:r-x u:www-data:r-x")
_VAR_CACHE_M_MDTX_MD5SUMS=("root" "root"  0750 "u:%s:rwx g:%s:rwx")
_VAR_CACHE_M_MDTX_JAIL=("root" "root"  0755 "NO ACL")
