#!/bin/bash
#set -x
set -e

echo "** $0 **"

DIRNAME=$(dirname $0)
BASENAME=$1
shift

# cleanup
rm -f ${BASENAME}_extNNN.txt
rm -f ${BASENAME}_catNNN.txt

# convert seda
$DIRNAME/../src/xml2txt -b $BASENAME

# test backward conversion to xml
$DIRNAME/../src/txt2xml -b $BASENAME -z $BASENAME.zip $@
xmllint --format $BASENAME.xml > $BASENAME.xml-old
xmllint --format $BASENAME.xml-new > tmp
mv tmp $BASENAME.xml-new
diff -wbB $BASENAME.xml-old $BASENAME.xml-new

echo "** OK: no difference with $BASENAME.xml-old **"
rm $BASENAME.xml-old $BASENAME.xml-new


