/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code;

public class CodeStyle {
    public static final CodeStyle JAVA = new CodeStyle(70, "    ");
    public static final CodeStyle CSHARP = new CodeStyle(70, "    ");
    private int margin;
    private String indentString;

    public CodeStyle(int margin, String indent) {
        this.margin = margin;
        this.indentString = indent;
    }

    public int getMargin() {
        return this.margin;
    }

    public String getIndent(int level) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < level) {
            buffer.append(this.indentString);
            ++i;
        }
        return buffer.toString();
    }

    public String getStringConstant(String str) {
        StringBuffer res = new StringBuffer();
        res.append('\"');
        res.append(this.addStringEscapes(str));
        res.append('\"');
        return res.toString();
    }

    public String getUpperCase(String str) {
        StringBuffer res = new StringBuffer();
        char last = 'A';
        int i = 0;
        while (i < str.length()) {
            if (Character.isLowerCase(last) && Character.isUpperCase(str.charAt(i))) {
                res.append("_");
            }
            if ('A' <= (last = str.charAt(i)) && last <= 'Z' || 'a' <= last && last <= 'z' || '0' <= last && last <= '9' || last == '_') {
                res.append(Character.toUpperCase(last));
            }
            ++i;
        }
        return res.toString();
    }

    public String getLowerCase(String str) {
        StringBuffer res = new StringBuffer();
        char last = 'A';
        int i = 0;
        while (i < str.length()) {
            if (Character.isLowerCase(last) && Character.isUpperCase(str.charAt(i))) {
                res.append("_");
            }
            if ('A' <= (last = str.charAt(i)) && last <= 'Z' || 'a' <= last && last <= 'z' || '0' <= last && last <= '9' || last == '_') {
                res.append(Character.toLowerCase(last));
            }
            ++i;
        }
        return res.toString();
    }

    public String getMixedCase(String str, boolean initialUpper) {
        StringBuffer res = new StringBuffer();
        char last = 'A';
        int i = 0;
        while (i < str.length()) {
            if (Character.isLowerCase(last) && Character.isUpperCase(str.charAt(i))) {
                initialUpper = true;
            } else if (str.charAt(i) == '_') {
                initialUpper = true;
            }
            last = str.charAt(i);
            if ('A' <= last && last <= 'Z' || 'a' <= last && last <= 'z' || '0' <= last && last <= '9') {
                if (initialUpper) {
                    res.append(Character.toUpperCase(last));
                    initialUpper = false;
                } else {
                    res.append(Character.toLowerCase(last));
                }
            }
            ++i;
        }
        return res.toString();
    }

    public String addStringEscapes(String str) {
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\"') {
                res.append("\\\"");
            } else if (str.charAt(i) == '\\') {
                res.append("\\\\");
            } else {
                res.append(str.charAt(i));
            }
            ++i;
        }
        return res.toString();
    }
}

