/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Vector;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaModifier;

public class JavaMethod
extends CodeElement {
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE_LOCAL = 2;
    public static final int PRIVATE = 3;
    public static final int STATIC = 4;
    public static final int ABSTRACT = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int NATIVE = 64;
    public static final int STRICTFP = 512;
    private int modifiers;
    private String name;
    private String args;
    private String returnType;
    private Vector throwList;
    private Vector code;
    private JavaComment comment;
    private boolean printCode;

    public JavaMethod(String name) {
        this(name, "");
    }

    public JavaMethod(String name, String args) {
        this(name, args, "void");
    }

    public JavaMethod(String name, String args, String returnType) {
        this(0, name, args, returnType);
    }

    public JavaMethod(int modifiers, String name, String args, String returnType) {
        this.modifiers = modifiers;
        this.name = name;
        this.args = args;
        this.returnType = returnType;
        this.throwList = new Vector();
        this.code = new Vector();
        this.comment = null;
        this.printCode = true;
    }

    public void addThrows(String className) {
        this.throwList.add(className);
    }

    public void addCode(String codeLines) {
        int pos = codeLines.indexOf(10);
        while (pos >= 0) {
            this.code.add(codeLines.substring(0, pos));
            codeLines = codeLines.substring(pos + 1);
            pos = codeLines.indexOf(10);
        }
        this.code.add(codeLines);
    }

    public void addComment(JavaComment comment) {
        this.comment = comment;
    }

    public int category() {
        return (this.modifiers & 4) > 0 ? 6 : 8;
    }

    public boolean canPrintCode() {
        return this.printCode && (this.modifiers & 8) == 0;
    }

    public void setPrintCode(boolean value) {
        this.printCode = value;
    }

    public void print(PrintWriter out, CodeStyle style, int indent) {
        String indentStr = style.getIndent(indent);
        String codeIndentStr = style.getIndent(indent + 1);
        StringBuffer res = new StringBuffer();
        boolean brokenThrows = false;
        if (this.comment != null) {
            this.comment.print(out, style, indent);
        }
        res.append(indentStr);
        res.append(JavaModifier.createModifierDecl(this.modifiers));
        res.append(this.returnType);
        res.append(" ");
        res.append(this.name);
        res.append("(");
        res.append(this.args);
        res.append(")");
        String str = this.getThrowDecl();
        if (str.length() > 0) {
            if (res.length() + str.length() < style.getMargin()) {
                res.append(" ");
            } else {
                res.append("\n");
                res.append(codeIndentStr);
                brokenThrows = true;
            }
            res.append(str);
        }
        if (this.canPrintCode()) {
            res.append(" {\n");
            if (brokenThrows && this.code.size() > 0) {
                res.append("\n");
            }
            int i = 0;
            while (i < this.code.size()) {
                if (this.code.elementAt(i).toString().length() > 0) {
                    res.append(codeIndentStr);
                    res.append(this.code.elementAt(i).toString());
                    res.append("\n");
                } else {
                    res.append("\n");
                }
                ++i;
            }
            res.append(indentStr);
            res.append("}");
        } else {
            res.append(";");
        }
        out.println(res.toString());
    }

    private String getThrowDecl() {
        StringBuffer res = new StringBuffer("throws ");
        if (this.throwList.size() == 0) {
            return "";
        }
        Collections.sort(this.throwList);
        int i = 0;
        while (i < this.throwList.size()) {
            res.append(this.throwList.elementAt(i).toString());
            if (i < this.throwList.size() - 1) {
                res.append(", ");
            }
            ++i;
        }
        return res.toString();
    }
}

