/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.csharp.CSharpClass;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpConstructor;
import net.percederberg.grammatica.code.csharp.CSharpEnumeration;
import net.percederberg.grammatica.code.csharp.CSharpFile;
import net.percederberg.grammatica.code.csharp.CSharpMethod;
import net.percederberg.grammatica.code.csharp.CSharpNamespace;
import net.percederberg.grammatica.code.csharp.CSharpUsing;
import net.percederberg.grammatica.output.CSharpConstantsFile;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.output.CSharpTokenizerFile;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;

class CSharpParserFile {
    private static final String TYPE_COMMENT = "<remarks>A token stream parser.</remarks>";
    private static final String ENUM_COMMENT = "<summary>An enumeration with the generated production node\nidentity constants.</summary>";
    private static final String CONSTRUCTOR1_COMMENT = "<summary>Creates a new parser.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private static final String CONSTRUCTOR2_COMMENT = "<summary>Creates a new parser.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<param name='analyzer'>the analyzer to parse with</param>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private static final String INIT_METHOD_COMMENT = "<summary>Initializes the parser by creating all the production\npatterns.</summary>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private CSharpParserGenerator gen;
    private CSharpTokenizerFile tokenizer;
    private CSharpFile file;
    private CSharpClass cls;
    private CSharpEnumeration enm;
    private CSharpMethod initMethod;
    private HashMap constantNames = new HashMap();
    private int constantId = 1;

    public CSharpParserFile(CSharpParserGenerator gen, CSharpTokenizerFile tokenizer) {
        String name = gen.getBaseName() + "Parser";
        this.gen = gen;
        this.tokenizer = tokenizer;
        this.file = new CSharpFile(gen.getBaseDir(), name);
        int modifiers = gen.getPublicAccess() ? 1 : 4;
        this.cls = new CSharpClass(modifiers, name, "RecursiveDescentParser");
        this.enm = new CSharpEnumeration(5, "SynteticPatterns");
        this.initMethod = new CSharpMethod(5, "CreatePatterns", "", "void");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addUsing(new CSharpUsing("System.IO"));
        this.file.addUsing(new CSharpUsing("PerCederberg.Grammatica.Parser"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            CSharpNamespace n = new CSharpNamespace(this.gen.getNamespace());
            n.addClass(this.cls);
            this.file.addNamespace(n);
        }
        String str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new CSharpComment(2, str));
        this.cls.addComment(new CSharpComment(TYPE_COMMENT));
        this.cls.addEnumeration(this.enm);
        this.enm.addComment(new CSharpComment(ENUM_COMMENT));
        CSharpConstructor constr = new CSharpConstructor("TextReader input");
        this.cls.addConstructor(constr);
        constr.addComment(new CSharpComment(CONSTRUCTOR1_COMMENT));
        constr.addInitializer("base(" + this.tokenizer.getConstructorCall("input") + ")");
        constr.addCode("CreatePatterns();");
        constr = new CSharpConstructor("TextReader input, Analyzer analyzer");
        this.cls.addConstructor(constr);
        constr.addComment(new CSharpComment(CONSTRUCTOR2_COMMENT));
        constr.addInitializer("base(" + this.tokenizer.getConstructorCall("input") + ", analyzer)");
        constr.addCode("CreatePatterns();");
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new CSharpComment(INIT_METHOD_COMMENT));
        this.initMethod.addCode("ProductionPattern             pattern;");
        this.initMethod.addCode("ProductionPatternAlternative  alt;");
    }

    public void addProductionConstant(ProductionPattern pattern) {
        if (pattern.isSyntetic()) {
            String constant = "SUBPRODUCTION_" + this.constantId;
            this.enm.addConstant(constant, String.valueOf(this.constantId + 3000));
            this.constantNames.put(new Integer(pattern.getId()), constant);
            ++this.constantId;
        }
    }

    public void addProduction(ProductionPattern pattern, CSharpConstantsFile constants) {
        StringBuffer code = new StringBuffer();
        code.append("pattern = new ProductionPattern((int) ");
        code.append(this.getConstant(constants, pattern.getId()));
        code.append(",\n");
        code.append("                                \"");
        if (pattern.isSyntetic()) {
            String str = (String)this.constantNames.get(new Integer(pattern.getId()));
            code.append(this.gen.getCodeStyle().getMixedCase(str, true));
        } else {
            code.append(pattern.getName());
        }
        code.append("\");");
        this.initMethod.addCode("");
        this.initMethod.addCode(code.toString());
        if (pattern.isSyntetic()) {
            this.initMethod.addCode("pattern.SetSyntetic(true);");
        }
        int i = 0;
        while (i < pattern.getAlternativeCount()) {
            this.addProductionAlternative(pattern.getAlternative(i), constants);
            ++i;
        }
        this.initMethod.addCode("AddPattern(pattern);");
    }

    private void addProductionAlternative(ProductionPatternAlternative alt, CSharpConstantsFile constants) {
        this.initMethod.addCode("alt = new ProductionPatternAlternative();");
        int i = 0;
        while (i < alt.getElementCount()) {
            ProductionPatternElement elem = alt.getElement(i);
            StringBuffer code = new StringBuffer();
            code.append("alt.");
            if (elem.isToken()) {
                code.append("AddToken(");
            } else {
                code.append("AddProduction(");
            }
            code.append("(int) ");
            code.append(this.getConstant(constants, elem.getId()));
            code.append(", ");
            code.append(elem.getMinCount());
            code.append(", ");
            if (elem.getMaxCount() == Integer.MAX_VALUE) {
                code.append("-1");
            } else {
                code.append(elem.getMaxCount());
            }
            code.append(");");
            this.initMethod.addCode(code.toString());
            ++i;
        }
        this.initMethod.addCode("pattern.AddAlternative(alt);");
    }

    private String getConstant(CSharpConstantsFile constants, int id) {
        Integer value = new Integer(id);
        if (this.constantNames.containsKey(value)) {
            return "SynteticPatterns." + this.constantNames.get(value);
        }
        return constants.getConstant(id);
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

