/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.Production;

public class Analyzer {
    public Node analyze(Node node) throws ParserLogException {
        ParserLogException log = new ParserLogException();
        node = this.analyze(node, log);
        if (log.getErrorCount() > 0) {
            throw log;
        }
        return node;
    }

    private Node analyze(Node node, ParserLogException log) {
        block12: {
            int errorCount = log.getErrorCount();
            if (node instanceof Production) {
                Production prod = (Production)node;
                prod = new Production(prod.getPattern());
                try {
                    this.enter(prod);
                }
                catch (ParseException e) {
                    log.addError(e);
                }
                int i = 0;
                while (i < node.getChildCount()) {
                    try {
                        this.child(prod, this.analyze(node.getChildAt(i), log));
                    }
                    catch (ParseException e) {
                        log.addError(e);
                    }
                    ++i;
                }
                try {
                    return this.exit(prod);
                }
                catch (ParseException e) {
                    if (errorCount != log.getErrorCount()) break block12;
                    log.addError(e);
                    break block12;
                }
            }
            node.removeAllValues();
            try {
                this.enter(node);
            }
            catch (ParseException e) {
                log.addError(e);
            }
            try {
                return this.exit(node);
            }
            catch (ParseException e) {
                if (errorCount != log.getErrorCount()) break block12;
                log.addError(e);
            }
        }
        return null;
    }

    protected void enter(Node node) throws ParseException {
    }

    protected Node exit(Node node) throws ParseException {
        return node;
    }

    protected void child(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected Node getChildAt(Node node, int pos) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        Node child = node.getChildAt(pos);
        if (child == null) {
            throw new ParseException(0, "node '" + node.getName() + "' has no child at " + "position " + pos, node.getStartLine(), node.getStartColumn());
        }
        return child;
    }

    protected Node getChildWithId(Node node, int id) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            if (child != null && child.getId() == id) {
                return child;
            }
            ++i;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no child with id " + id, node.getStartLine(), node.getStartColumn());
    }

    protected Object getValue(Node node, int pos) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        Object value = node.getValue(pos);
        if (value == null) {
            throw new ParseException(0, "node '" + node.getName() + "' has no value at " + "position " + pos, node.getStartLine(), node.getStartColumn());
        }
        return value;
    }

    protected int getIntValue(Node node, int pos) throws ParseException {
        Object value = this.getValue(node, pos);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no integer value " + "at position " + pos, node.getStartLine(), node.getStartColumn());
    }

    protected String getStringValue(Node node, int pos) throws ParseException {
        Object value = this.getValue(node, pos);
        if (value instanceof String) {
            return (String)value;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no string value " + "at position " + pos, node.getStartLine(), node.getStartColumn());
    }

    protected ArrayList getChildValues(Node node) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            ArrayList values = child.getAllValues();
            if (values != null) {
                result.addAll(values);
            }
            ++i;
        }
        return result;
    }
}

