/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public abstract class Parser {
    private boolean initialized = false;
    private Tokenizer tokenizer;
    private Analyzer analyzer;
    private ArrayList patterns = new ArrayList();
    private HashMap patternIds = new HashMap();
    private ArrayList tokens = new ArrayList();
    private ParserLogException errorLog = new ParserLogException();
    private int errorRecovery = -1;

    Parser(Tokenizer tokenizer) {
        this(tokenizer, new Analyzer());
    }

    Parser(Tokenizer tokenizer, Analyzer analyzer) {
        this.tokenizer = tokenizer;
        this.analyzer = analyzer;
    }

    void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void addPattern(ProductionPattern pattern) throws ParserCreationException {
        Integer id = new Integer(pattern.getId());
        if (pattern.getAlternativeCount() <= 0) {
            throw new ParserCreationException(3, pattern.getName(), "no production alternatives are present (must have at least one)");
        }
        if (this.patternIds.containsKey(id)) {
            throw new ParserCreationException(3, pattern.getName(), "another pattern with the same id (" + id + ") has already been added");
        }
        this.patterns.add(pattern);
        this.patternIds.put(id, pattern);
        this.setInitialized(false);
    }

    public void prepare() throws ParserCreationException {
        if (this.patterns.size() <= 0) {
            throw new ParserCreationException(1, "no production patterns have been added");
        }
        int i = 0;
        while (i < this.patterns.size()) {
            this.checkPattern((ProductionPattern)this.patterns.get(i));
            ++i;
        }
        this.setInitialized(true);
    }

    private void checkPattern(ProductionPattern pattern) throws ParserCreationException {
        int i = 0;
        while (i < pattern.getAlternativeCount()) {
            this.checkRule(pattern.getName(), pattern.getAlternative(i));
            ++i;
        }
    }

    private void checkRule(String name, ProductionPatternAlternative rule) throws ParserCreationException {
        int i = 0;
        while (i < rule.getElementCount()) {
            this.checkElement(name, rule.getElement(i));
            ++i;
        }
    }

    private void checkElement(String name, ProductionPatternElement elem) throws ParserCreationException {
        if (elem.isProduction() && this.getPattern(elem.getId()) == null) {
            throw new ParserCreationException(3, name, "an undefined production pattern id (" + elem.getId() + ") is referenced");
        }
    }

    public Node parse() throws ParserCreationException, ParserLogException {
        Node root = null;
        if (!this.initialized) {
            this.prepare();
        }
        try {
            root = this.parseStart();
        }
        catch (ParseException e) {
            this.addError(e, true);
        }
        if (this.errorLog.getErrorCount() > 0) {
            throw this.errorLog;
        }
        return root;
    }

    protected abstract Node parseStart() throws ParseException;

    void addError(ParseException e, boolean recovery) {
        if (this.errorRecovery <= 0) {
            this.errorLog.addError(e);
        }
        if (recovery) {
            this.errorRecovery = 3;
        }
    }

    ProductionPattern getPattern(int id) {
        Integer value = new Integer(id);
        return (ProductionPattern)this.patternIds.get(value);
    }

    ProductionPattern getStartPattern() {
        if (this.patterns.size() <= 0) {
            return null;
        }
        return (ProductionPattern)this.patterns.get(0);
    }

    Collection getPatterns() {
        return this.patterns;
    }

    void enterNode(Node node) {
        block2: {
            if (node.isHidden() || this.errorRecovery >= 0) break block2;
            try {
                this.analyzer.enter(node);
            }
            catch (ParseException e) {
                this.addError(e, false);
            }
        }
    }

    Node exitNode(Node node) {
        if (!node.isHidden() && this.errorRecovery < 0) {
            try {
                return this.analyzer.exit(node);
            }
            catch (ParseException e) {
                this.addError(e, false);
            }
        }
        return node;
    }

    void addNode(Production node, Node child) {
        block7: {
            if (this.errorRecovery >= 0) break block7;
            if (node.isHidden()) {
                node.addChild(child);
            } else if (child != null && child.isHidden()) {
                int i = 0;
                while (i < child.getChildCount()) {
                    this.addNode(node, child.getChildAt(i));
                    ++i;
                }
            } else {
                try {
                    this.analyzer.child(node, child);
                }
                catch (ParseException e) {
                    this.addError(e, false);
                }
            }
        }
    }

    Token nextToken() throws ParseException {
        Token token = this.peekToken(0);
        if (token != null) {
            this.tokens.remove(0);
            return token;
        }
        throw new ParseException(2, null, this.tokenizer.getCurrentLine(), this.tokenizer.getCurrentColumn());
    }

    Token nextToken(int id) throws ParseException {
        Token token = this.nextToken();
        if (token.getId() == id) {
            if (this.errorRecovery > 0) {
                --this.errorRecovery;
            }
            return token;
        }
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(this.tokenizer.getPatternDescription(id));
        throw new ParseException(4, token.toShortString(), list, token.getStartLine(), token.getStartColumn());
    }

    Token peekToken(int steps) {
        while (steps >= this.tokens.size()) {
            try {
                Token token = this.tokenizer.next();
                if (token == null) {
                    return null;
                }
                this.tokens.add(token);
            }
            catch (ParseException e) {
                this.addError(e, true);
            }
        }
        return (Token)this.tokens.get(steps);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.patterns.size()) {
            buffer.append(this.toString((ProductionPattern)this.patterns.get(i)));
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    private String toString(ProductionPattern prod) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer indent = new StringBuffer();
        buffer.append(prod.getName());
        buffer.append(" (");
        buffer.append(prod.getId());
        buffer.append(") ");
        int i = 0;
        while (i < buffer.length()) {
            indent.append(" ");
            ++i;
        }
        buffer.append("= ");
        indent.append("| ");
        i = 0;
        while (i < prod.getAlternativeCount()) {
            if (i > 0) {
                buffer.append(indent);
            }
            buffer.append(this.toString(prod.getAlternative(i)));
            buffer.append("\n");
            ++i;
        }
        i = 0;
        while (i < prod.getAlternativeCount()) {
            LookAheadSet set = prod.getAlternative(i).getLookAhead();
            if (set.getMaxLength() > 1) {
                buffer.append("Using ");
                buffer.append(set.getMaxLength());
                buffer.append(" token look-ahead for alternative ");
                buffer.append(i + 1);
                buffer.append(": ");
                buffer.append(set.toString(this.tokenizer));
                buffer.append("\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    private String toString(ProductionPatternAlternative alt) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < alt.getElementCount()) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(this.toString(alt.getElement(i)));
            ++i;
        }
        return buffer.toString();
    }

    private String toString(ProductionPatternElement elem) {
        StringBuffer buffer = new StringBuffer();
        int min = elem.getMinCount();
        int max = elem.getMaxCount();
        if (min == 0 && max == 1) {
            buffer.append("[");
        }
        if (elem.isToken()) {
            buffer.append(this.getTokenDescription(elem.getId()));
        } else {
            buffer.append(this.getPattern(elem.getId()).getName());
        }
        if (min == 0 && max == 1) {
            buffer.append("]");
        } else if (min == 0 && max == Integer.MAX_VALUE) {
            buffer.append("*");
        } else if (min == 1 && max == Integer.MAX_VALUE) {
            buffer.append("+");
        } else if (min != 1 || max != 1) {
            buffer.append("{");
            buffer.append(min);
            buffer.append(",");
            buffer.append(max);
            buffer.append("}");
        }
        return buffer.toString();
    }

    String getTokenDescription(int token) {
        if (this.tokenizer == null) {
            return "";
        }
        return this.tokenizer.getPatternDescription(token);
    }
}

