/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.TokenPattern;

public class Token
extends Node {
    private TokenPattern pattern;
    private String image;
    private int startLine;
    private int startColumn;
    private int endLine;
    private int endColumn;

    public Token(TokenPattern pattern, String image, int line, int col) {
        this.pattern = pattern;
        this.image = image;
        this.startLine = line;
        this.startColumn = col;
        this.endLine = line;
        this.endColumn = col + image.length() - 1;
        int pos = 0;
        while (image.indexOf(10, pos) >= 0) {
            pos = image.indexOf(10, pos) + 1;
            ++this.endLine;
            this.endColumn = image.length() - pos;
        }
    }

    public int getId() {
        return this.pattern.getId();
    }

    public String getName() {
        return this.pattern.getName();
    }

    public String getImage() {
        return this.image;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    TokenPattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int newline = this.image.indexOf(10);
        buffer.append(this.pattern.getName());
        buffer.append("(");
        buffer.append(this.pattern.getId());
        buffer.append("): \"");
        if (newline >= 0) {
            if (newline > 0 && this.image.charAt(newline - 1) == '\r') {
                --newline;
            }
            buffer.append(this.image.substring(0, newline));
            buffer.append("(...)");
        } else {
            buffer.append(this.image);
        }
        buffer.append("\", line: ");
        buffer.append(this.startLine);
        buffer.append(", col: ");
        buffer.append(this.startColumn);
        return buffer.toString();
    }

    public String toShortString() {
        StringBuffer buffer = new StringBuffer();
        int newline = this.image.indexOf(10);
        buffer.append('\"');
        if (newline >= 0) {
            if (newline > 0 && this.image.charAt(newline - 1) == '\r') {
                --newline;
            }
            buffer.append(this.image.substring(0, newline));
            buffer.append("(...)");
        } else {
            buffer.append(this.image);
        }
        buffer.append('\"');
        if (this.pattern.getType() == 2) {
            buffer.append(" <");
            buffer.append(this.pattern.getName());
            buffer.append(">");
        }
        return buffer.toString();
    }
}

