/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import net.percederberg.mibble.FileLocation;

public class LogEntry {
    public static final int INTERNAL_ERROR = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;
    private int type;
    private FileLocation location;
    private String message;

    public LogEntry(int type, FileLocation location, String message) {
        this.type = type;
        this.location = location;
        this.message = message;
    }

    public boolean isError() {
        return this.type == 1 || this.type == 2;
    }

    public boolean isWarning() {
        return this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public File getFile() {
        return this.location.getFile();
    }

    public int getLineNumber() {
        return this.location.getLineNumber();
    }

    public int getColumnNumber() {
        return this.location.getColumnNumber();
    }

    public String getMessage() {
        return this.message;
    }

    public String readLine() {
        return this.location.readLine();
    }
}

