/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpModuleSupport;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpAgentCapabilities
implements MibType {
    private String productRelease;
    private SnmpStatus status;
    private String description;
    private String reference;
    private ArrayList modules;

    public SnmpAgentCapabilities(String productRelease, SnmpStatus status, String description, String reference, ArrayList modules) {
        this.productRelease = productRelease;
        this.status = status;
        this.description = description;
        this.reference = reference;
        this.modules = modules;
    }

    public MibType initialize(MibLoaderLog log) throws MibException {
        for (int i = 0; i < this.modules.size(); ++i) {
            ((SnmpModuleSupport)this.modules.get(i)).initialize(log);
        }
        return this;
    }

    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public String getProductRelease() {
        return this.productRelease;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public ArrayList getModules() {
        return this.modules;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AGENT-CAPABILITIES (");
        buffer.append("\n  Product Release: ");
        buffer.append(this.productRelease);
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.description);
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        for (int i = 0; i < this.modules.size(); ++i) {
            buffer.append("\n  Supports Module: ");
            buffer.append(this.modules.get(i));
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

