/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpTextualConvention;
import net.percederberg.mibble.type.BitSetType;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.StringType;

public class TypeReference
implements MibType,
MibContext {
    private FileLocation location;
    private MibContext context;
    private String name;
    private MibType type = null;
    private Constraint constraint = null;
    private ArrayList values = null;

    public TypeReference(FileLocation location, MibContext context, String name) {
        this.location = location;
        this.context = context;
        this.name = name;
    }

    public TypeReference(FileLocation location, MibContext context, String name, Constraint constraint) {
        this.location = location;
        this.context = context;
        this.name = name;
        this.constraint = constraint;
    }

    public TypeReference(FileLocation location, MibContext context, String name, ArrayList values) {
        this.location = location;
        this.context = context;
        this.name = name;
        this.values = values;
    }

    public MibType initialize(MibLoaderLog log) throws MibException {
        MibSymbol symbol = this.context.getSymbol(this.name);
        if (symbol instanceof MibTypeSymbol) {
            this.type = this.initialize(log, ((MibTypeSymbol)symbol).getType());
            return this.type;
        }
        if (symbol == null) {
            String message = "undefined symbol '" + this.name + "'";
            throw new MibException(this.location, message);
        }
        String message = "referenced symbol '" + this.name + "' is not a type";
        throw new MibException(this.location, message);
    }

    private MibType initialize(MibLoaderLog log, MibType type) throws MibException {
        type = type.initialize(log);
        if (this.constraint == null && this.values == null) {
            return type;
        }
        if (type instanceof IntegerType) {
            return this.initialize(log, (IntegerType)type);
        }
        if (type instanceof StringType) {
            return this.initialize(log, (StringType)type);
        }
        if (type instanceof BitSetType) {
            return this.initialize(log, (BitSetType)type);
        }
        if (type instanceof SnmpTextualConvention) {
            type = ((SnmpTextualConvention)type).getSyntax();
            return this.initialize(log, type);
        }
        throw new MibException(this.location, "type does not support constraints");
    }

    private MibType initialize(MibLoaderLog log, IntegerType type) throws MibException {
        if (this.values != null) {
            return new IntegerType(this.values).initialize(log);
        }
        return new IntegerType(this.constraint).initialize(log);
    }

    private MibType initialize(MibLoaderLog log, StringType type) throws MibException {
        if (this.values != null) {
            throw new MibException(this.location, "string type does not support defined values");
        }
        return new StringType(this.constraint).initialize(log);
    }

    private MibType initialize(MibLoaderLog log, BitSetType type) throws MibException {
        if (this.values != null) {
            return new BitSetType(this.values).initialize(log);
        }
        return new BitSetType(this.constraint).initialize(log);
    }

    public FileLocation getLocation() {
        return this.location;
    }

    public boolean isCompatible(MibValue value) {
        return false;
    }

    public MibSymbol getSymbol(String name) {
        if (this.type instanceof MibContext) {
            return ((MibContext)((Object)this.type)).getSymbol(name);
        }
        return null;
    }

    public String toString() {
        return "ReferenceToType(" + this.name + ")";
    }
}

