/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.mibble.MibAnalyzer;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibReference;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.asn1.Asn1Parser;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class Mib
implements MibContext {
    private File file;
    private MibLoader loader;
    private MibLoaderLog log;
    private String name = null;
    private ArrayList imports = new ArrayList();
    private ArrayList symbolList = new ArrayList();
    private HashMap symbolNameMap = new HashMap();
    private HashMap symbolValueMap = new HashMap();

    Mib(File file, MibLoader loader, MibLoaderLog log) throws FileNotFoundException, MibLoaderException {
        this(new FileReader(file), file, loader, log);
    }

    Mib(Reader input, File file, MibLoader loader, MibLoaderLog log) throws MibLoaderException {
        this.file = file;
        this.loader = loader;
        this.log = log;
        this.parse(input);
    }

    private void parse(Reader input) throws MibLoaderException {
        try {
            Asn1Parser parser = new Asn1Parser(input, new MibAnalyzer(this));
            parser.parse();
        }
        catch (ParserCreationException e) {
            String msg = "parser creation error in ASN.1 parser: " + e.getMessage();
            this.log.addInternalError(this.file, msg);
            throw new MibLoaderException(this.log);
        }
        catch (ParserLogException e) {
            this.log.addAll(this.file, e);
            throw new MibLoaderException(this.log);
        }
    }

    void initialize() throws MibLoaderException {
        int errors = this.log.errorCount();
        for (int i = 0; i < this.imports.size(); ++i) {
            MibReference ref = (MibReference)this.imports.get(i);
            try {
                ref.initialize(this.log);
                continue;
            }
            catch (MibException e) {
                this.log.addError(e.getLocation(), e.getMessage());
            }
        }
        if (errors != this.log.errorCount()) {
            throw new MibLoaderException(this.log);
        }
    }

    void validate() throws MibLoaderException {
        int errors = this.log.errorCount();
        for (int i = 0; i < this.symbolList.size(); ++i) {
            MibValueSymbol value;
            MibSymbol symbol = (MibSymbol)this.symbolList.get(i);
            try {
                symbol.initialize(this.log);
            }
            catch (MibException e) {
                this.log.addError(e.getLocation(), e.getMessage());
            }
            if (!(symbol instanceof MibValueSymbol) || !((value = (MibValueSymbol)symbol).getValue() instanceof NumberValue) && !(value.getValue() instanceof ObjectIdentifierValue)) continue;
            this.symbolValueMap.put(value.getValue().toString(), symbol);
        }
        if (errors != this.log.errorCount()) {
            throw new MibLoaderException(this.log);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.name.equals(obj);
        }
        if (obj instanceof File) {
            return this.file.equals(obj);
        }
        if (obj instanceof Mib) {
            return obj.equals(this.name);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return this.file;
    }

    public MibLoader getLoader() {
        return this.loader;
    }

    public MibLoaderLog getLog() {
        return this.log;
    }

    MibReference getImport(String name) {
        for (int i = 0; i < this.imports.size(); ++i) {
            MibReference ref = (MibReference)this.imports.get(i);
            if (!ref.getName().equals(name)) continue;
            return ref;
        }
        return null;
    }

    void addImport(MibReference ref) {
        this.imports.add(ref);
    }

    public Collection getAllSymbols() {
        return this.symbolList;
    }

    public MibSymbol getSymbol(String name) {
        return (MibSymbol)this.symbolNameMap.get(name);
    }

    public MibValueSymbol getSymbolByValue(String value) {
        return (MibValueSymbol)this.symbolValueMap.get(value);
    }

    public MibValueSymbol getSymbolByValue(MibValue value) {
        return (MibValueSymbol)this.symbolValueMap.get(value.toString());
    }

    void addSymbol(MibSymbol symbol) {
        this.symbolList.add(symbol);
        this.symbolNameMap.put(symbol.getName(), symbol);
    }

    public String toString() {
        return this.getName();
    }
}

