/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpModule;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpModuleCompliance
extends MibType {
    private SnmpStatus status;
    private String description;
    private String reference;
    private ArrayList modules;

    public SnmpModuleCompliance(SnmpStatus status, String description, String reference, ArrayList modules) {
        super("MODULE-COMPLIANCE", false);
        this.status = status;
        this.description = description;
        this.reference = reference;
        this.modules = modules;
    }

    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        if (!(symbol instanceof MibValueSymbol)) {
            throw new MibException(symbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        for (int i = 0; i < this.modules.size(); ++i) {
            ((SnmpModule)this.modules.get(i)).initialize(log);
        }
        return this;
    }

    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public ArrayList getModules() {
        return this.modules;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(" (");
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.description);
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        for (int i = 0; i < this.modules.size(); ++i) {
            buffer.append("\n  Module: ");
            buffer.append(this.modules.get(i));
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

