/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpVariation;

public class SnmpModuleSupport {
    private String module;
    private ArrayList groups;
    private ArrayList variations;

    public SnmpModuleSupport(String module, ArrayList groups, ArrayList variations) {
        this.module = module;
        this.groups = groups;
        this.variations = variations;
    }

    void initialize(MibLoaderLog log) throws MibException {
        int i;
        ArrayList<MibValue> list = new ArrayList<MibValue>();
        for (i = 0; i < this.groups.size(); ++i) {
            list.add(((MibValue)this.groups.get(i)).initialize(log));
        }
        this.groups = list;
        for (i = 0; i < this.variations.size(); ++i) {
            ((SnmpVariation)this.variations.get(i)).initialize(log);
        }
    }

    public String getModule() {
        return this.module;
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public ArrayList getVariations() {
        return this.variations;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.module != null) {
            buffer.append(this.module);
        }
        buffer.append("\n    Includes: ");
        buffer.append(this.groups);
        for (int i = 0; i < this.variations.size(); ++i) {
            buffer.append("\n    Variation: ");
            buffer.append(this.variations.get(i));
        }
        return buffer.toString();
    }
}

