/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpNotificationGroup
extends MibType {
    private ArrayList notifications;
    private SnmpStatus status;
    private String description;
    private String reference;

    public SnmpNotificationGroup(ArrayList notifications, SnmpStatus status, String description, String reference) {
        super("NOTIFICATION-GROUP", false);
        this.notifications = notifications;
        this.status = status;
        this.description = description;
        this.reference = reference;
    }

    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        ArrayList<MibValue> list = new ArrayList<MibValue>();
        if (!(symbol instanceof MibValueSymbol)) {
            throw new MibException(symbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        for (int i = 0; i < this.notifications.size(); ++i) {
            list.add(((MibValue)this.notifications.get(i)).initialize(log));
        }
        this.notifications = list;
        return this;
    }

    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public ArrayList getNotifications() {
        return this.notifications;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(" (");
        buffer.append("\n  Notifications: ");
        buffer.append(this.notifications);
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.description);
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

