/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.pdu.OneGetNextPdu;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.varbind;

public class NTPrintQBean
extends SNMPRunBean
implements Observer {
    private static final String version_id = "@(#)$Id: NTPrintQBean.java,v 1.10 2002/10/10 15:13:56 birgit Exp $ Copyright Westhawk Ltd";
    public static final String svPrintQName = "1.3.6.1.4.1.77.1.2.29.1.1";
    private int svPrintQName_len;
    private OneGetNextPdu pdu;
    private Hashtable printHash = new Hashtable();
    private boolean isGetNextInFlight;
    private Date lastUpdateDate = null;

    public NTPrintQBean() {
        this.svPrintQName_len = svPrintQName.length();
    }

    public NTPrintQBean(String h, int p) {
        this();
        this.setHost(h);
        this.setPort(p);
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Enumeration getIndices() {
        return this.printHash.elements();
    }

    public String getIndex(String name) {
        return (String)this.printHash.get(name);
    }

    public Enumeration getNames() {
        return this.printHash.keys();
    }

    public synchronized int getCount() {
        return this.printHash.size();
    }

    public void action() {
        if (this.isHostPortReachable()) {
            this.printHash.clear();
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.setRunning(true);
        }
    }

    public void run() {
        while (this.context != null && this.isRunning()) {
            if (!this.isGetNextInFlight) {
                this.isGetNextInFlight = true;
                this.pdu = new OneGetNextPdu(this.context);
                this.pdu.addObserver(this);
                this.pdu.addOid(svPrintQName);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void update(Observable obs, Object ov) {
        this.pdu = (OneGetNextPdu)obs;
        if (this.pdu.getErrorStatus() == 0) {
            varbind var = (varbind)ov;
            String oid = "";
            if (var != null) {
                oid = var.getOid().toString();
            }
            if (oid.startsWith(svPrintQName)) {
                String index = oid.substring(this.svPrintQName_len + 1);
                String name = ((AsnOctets)var.getValue()).getValue();
                this.printHash.put(name, index);
                this.pdu = new OneGetNextPdu(this.context);
                this.pdu.addObserver(this);
                this.pdu.addOid(oid);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            } else {
                this.lastUpdateDate = new Date();
                this.isGetNextInFlight = false;
                this.firePropertyChange("resourceNames", null, null);
            }
        } else {
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.firePropertyChange("resourceNames", null, null);
        }
    }
}

