/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import uk.co.westhawk.snmp.event.TrapListener;
import uk.co.westhawk.snmp.event.TrapReceivedSupport;
import uk.co.westhawk.snmp.net.ContextSocketFace;
import uk.co.westhawk.snmp.stack.AbstractSnmpContext;
import uk.co.westhawk.snmp.stack.AsnDecoder;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public class DefaultTrapContext
implements Runnable {
    private static final String version_id = "@(#)$Id: DefaultTrapContext.java,v 3.8 2002/11/18 14:08:20 birgit Exp $ Copyright Westhawk Ltd";
    public static final int DEFAULT_TRAP_PORT = 162;
    private static DefaultTrapContext current = null;
    private ContextSocketFace soc;
    private Thread me;
    private String basename;
    protected int maxRecvSize;
    private transient TrapReceivedSupport trapSupport;
    private transient TrapReceivedSupport unhandledSupport;

    protected DefaultTrapContext(int port) throws IOException {
        this(port, "Standard");
    }

    protected DefaultTrapContext(int port, String typeSocketA) throws IOException {
        this.basename = "" + port;
        this.trapSupport = new TrapReceivedSupport(this);
        this.unhandledSupport = new TrapReceivedSupport(this);
        this.maxRecvSize = 1300;
        this.soc = AbstractSnmpContext.getSocket(typeSocketA);
        this.soc.create(port);
    }

    public static synchronized DefaultTrapContext getInstance(int port) throws IOException {
        if (current == null) {
            current = new DefaultTrapContext(port);
        }
        return current;
    }

    public static synchronized DefaultTrapContext getInstance(int port, String typeSocketA) throws IOException {
        if (current == null) {
            current = new DefaultTrapContext(port, typeSocketA);
        }
        return current;
    }

    protected void startListening() {
        if (this.me == null) {
            this.me = new Thread((Runnable)this, this.basename + "_Receive");
            this.me.setPriority(5);
            this.me.start();
        }
    }

    public int getMaxRecvSize() {
        return this.maxRecvSize;
    }

    public void setMaxRecvSize(int no) {
        this.maxRecvSize = no;
    }

    public synchronized void destroy() {
        if (this.me != null) {
            this.me = null;
        }
        this.soc.close();
        if (AsnObject.debug > 12) {
            System.out.println("DefaultTrapContext.destroy(): Socket closed ");
        }
    }

    public void run() {
        while (this.me != null) {
            Thread.yield();
            try {
                AsnSequence asnTopSeq;
                AsnDecoder rpdu;
                int version;
                boolean isConsumed;
                if (this.me == null) break;
                ByteArrayInputStream in = this.soc.receive(this.maxRecvSize);
                String hostAddress = this.soc.getHostAddress();
                byte[] bu = null;
                int nb = in.available();
                bu = new byte[nb];
                in.read(bu);
                in.close();
                if (AsnObject.debug > 10) {
                    SnmpUtilities.dumpBytes("DefaultTrapContext.run(): Received packet", bu);
                }
                if (isConsumed = this.trapSupport.fireTrapReceived(version = (rpdu = new AsnDecoder()).getSNMPVersion(asnTopSeq = rpdu.getAsnSequence(in = new ByteArrayInputStream(bu))), hostAddress, bu)) continue;
                this.unhandledSupport.fireTrapReceived(version, hostAddress, bu);
            }
            catch (IOException exc) {
                if (exc instanceof InterruptedIOException) {
                    if (AsnObject.debug <= 15) continue;
                    System.out.println("DefaultTrapContext.run(): Idle recv " + exc.getMessage());
                    continue;
                }
                if (AsnObject.debug <= 0) continue;
                System.out.println("DefaultTrapContext.run(): IOException: " + exc.getMessage());
            }
            catch (DecodingException exc) {
                if (AsnObject.debug <= 1) continue;
                System.out.println("DefaultTrapContext.run(): DecodingException: " + exc.getMessage());
            }
            catch (Exception exc) {
                if (AsnObject.debug <= 0) continue;
                System.out.println("DefaultTrapContext.run(): Exception: " + exc.getMessage());
                exc.printStackTrace();
            }
        }
        this.trapSupport.empty();
        this.unhandledSupport.empty();
    }

    public void addTrapListener(TrapListener listener) {
        this.trapSupport.addTrapListener(listener);
        this.startListening();
    }

    public void removeTrapListener(TrapListener listener) {
        this.trapSupport.removeTrapListener(listener);
    }

    public void addUnhandledTrapListener(TrapListener listener) {
        this.unhandledSupport.addTrapListener(listener);
        this.startListening();
    }

    public void removeUnhandledTrapListener(TrapListener listener) {
        this.unhandledSupport.removeTrapListener(listener);
    }
}

