/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import uk.co.westhawk.snmp.pdu.OneTrapPduv1;
import uk.co.westhawk.snmp.stack.AbstractSnmpContext;
import uk.co.westhawk.snmp.stack.AsnDecoder;
import uk.co.westhawk.snmp.stack.AsnEncoder;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.AsnTrapPduv1Sequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.SnmpContextFace;

public class SnmpContext
extends AbstractSnmpContext
implements SnmpContextFace,
Cloneable {
    private static final String version_id = "@(#)$Id: SnmpContext.java,v 3.18 2002/10/23 11:48:01 birgit Exp $ Copyright Westhawk Ltd";
    public static final String Default_Community = "public";
    String community = "public";

    public SnmpContext(String host, int port) throws IOException {
        super(host, port);
    }

    public SnmpContext(String host, int port, String typeSocketA) throws IOException {
        super(host, port, typeSocketA);
    }

    public int getVersion() {
        return 0;
    }

    public String getCommunity() {
        return this.community;
    }

    public void setCommunity(String newCommunity) {
        this.community = newCommunity;
    }

    public byte[] encodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve) throws IOException, EncodingException {
        byte[] packet = null;
        if (this.isDestroyed) {
            throw new EncodingException("Context can no longer be used, since it is already destroyed");
        }
        AsnEncoder enc = new AsnEncoder();
        ByteArrayOutputStream bay = enc.EncodeSNMP(this, msg_type, rId, errstat, errind, ve);
        int sz = bay.size();
        if (sz > this.maxRecvSize) {
            throw new EncodingException("Packet size (" + sz + ") is > maximum size (" + this.maxRecvSize + ")");
        }
        packet = bay.toByteArray();
        return packet;
    }

    public byte[] encodePacket(byte msg_type, String enterprise, byte[] IpAddress, int generic_trap, int specific_trap, long timeTicks, Enumeration ve) throws IOException, EncodingException {
        byte[] packet = null;
        AsnEncoder enc = new AsnEncoder();
        ByteArrayOutputStream bay = enc.EncodeSNMP(this, msg_type, enterprise, IpAddress, generic_trap, specific_trap, timeTicks, ve);
        int sz = bay.size();
        if (sz > this.maxRecvSize) {
            throw new EncodingException("Packet size (" + sz + ") is > maximum size (" + this.maxRecvSize + ")");
        }
        packet = bay.toByteArray();
        return packet;
    }

    protected void ProcessIncomingMessage(AsnDecoder rpdu, ByteArrayInputStream in) throws DecodingException, IOException {
        AsnPduSequence pduSeq = rpdu.DecodeSNMP(in, this.getCommunity());
        if (pduSeq != null) {
            Integer rid = new Integer(pduSeq.getReqId());
            Pdu answ = this.getPdu(rid);
            if (answ != null) {
                answ.fillin(pduSeq);
            } else if (AsnObject.debug > 3) {
                System.out.println("ProcessIncomingMessage(): No Pdu with reqid " + rid);
            }
        } else if (AsnObject.debug > 3) {
            System.out.println("ProcessIncomingMessage(): Error - missing seq input");
        }
    }

    public Pdu processIncomingTrap(byte[] message) throws DecodingException, IOException {
        AsnDecoder rpdu = new AsnDecoder();
        ByteArrayInputStream in = new ByteArrayInputStream(message);
        AsnTrapPduv1Sequence pduSeq = rpdu.DecodeTrap1Pdu(in, this.getCommunity());
        OneTrapPduv1 trapPdu = new OneTrapPduv1(this);
        trapPdu.fillin(pduSeq);
        return trapPdu;
    }

    public Object clone() throws CloneNotSupportedException {
        SnmpContext clContext = null;
        try {
            clContext = new SnmpContext(this.hostAddr, this.hostPort, this.typeSocket);
            clContext.setCommunity(new String(this.community));
        }
        catch (IOException exc) {
            throw new CloneNotSupportedException("IOException " + exc.getMessage());
        }
        return clContext;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("SnmpContext[");
        buffer.append("host=").append(this.hostAddr);
        buffer.append(", port=").append(this.hostPort);
        buffer.append(", socketType=").append(this.typeSocket);
        buffer.append(", community=").append(this.community);
        buffer.append("]");
        return buffer.toString();
    }
}

