/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.util.Enumeration;
import java.util.Hashtable;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.TimeWindowNode;

public class TimeWindow {
    private static final String version_id = "@(#)$Id: TimeWindow.java,v 3.9 2002/10/10 15:13:57 birgit Exp $ Copyright Westhawk Ltd";
    public static final int MaxTimeDifference = 150;
    private static TimeWindow current = null;
    private Hashtable hostLookup;
    private Hashtable engineLookup;
    private long startTime;

    public TimeWindow() {
        if (current == null) {
            current = this;
            this.hostLookup = new Hashtable(5);
            this.engineLookup = new Hashtable(5);
        }
    }

    public static TimeWindow getCurrent() {
        return current;
    }

    public String getSnmpEngineId(String host, int port) {
        String key = this.getKey(host, port);
        String snmpEngineId = (String)this.hostLookup.get(key);
        return snmpEngineId;
    }

    public boolean isSnmpEngineIdKnown(String host, int port) {
        String key = this.getKey(host, port);
        return this.hostLookup.containsKey(key);
    }

    public void setSnmpEngineId(String host, int port, String snmpEngineId) {
        String key = this.getKey(host, port);
        this.hostLookup.put(key, snmpEngineId);
        if (AsnObject.debug > 4) {
            System.out.println();
            System.out.println("TimeWindow.setSnmpEngineId(): host " + host + ", port " + port + ", snmpEngineId " + snmpEngineId);
        }
    }

    public boolean isEngineIdOK(String host, int port, String snmpEngineId) {
        boolean ok = true;
        String key = this.getKey(host, port);
        if (!this.hostLookup.containsKey(key)) {
            this.setSnmpEngineId(host, port, snmpEngineId);
        } else {
            String myEngineId = this.getSnmpEngineId(host, port);
            if (!myEngineId.equals(snmpEngineId)) {
                ok = false;
            }
        }
        return ok;
    }

    public boolean isTimeLineKnown(String snmpEngineId) {
        return this.engineLookup.containsKey(snmpEngineId);
    }

    public boolean isOutsideTimeWindow(String snmpEngineId, int bootsA, int timeA) {
        boolean isOut = false;
        TimeWindowNode node = this.getTimeLine(snmpEngineId);
        if (node != null) {
            int bootsL = node.getSnmpEngineBoots();
            int timeL = node.getSnmpEngineTime();
            if (bootsA == Integer.MAX_VALUE || bootsA < bootsL || bootsA == bootsL && timeA < timeL - 150) {
                isOut = true;
            }
        } else {
            isOut = false;
        }
        return isOut;
    }

    public boolean updateTimeWindow(String snmpEngineId, int bootsA, int timeA, boolean isAuthentic) {
        boolean updated = false;
        TimeWindowNode node = this.getTimeLine(snmpEngineId);
        if (node != null) {
            if (isAuthentic) {
                int bootsL = node.getSnmpEngineBoots();
                int latestL = node.getLatestReceivedEngineTime();
                if (bootsA > bootsL || bootsA == bootsL && timeA > latestL) {
                    TimeWindow timeWindow = this;
                    synchronized (timeWindow) {
                        node.setSnmpEngineBoots(bootsA);
                        node.setSnmpEngineTime(timeA);
                        updated = true;
                    }
                }
            }
        } else if (bootsA > 0) {
            node = new TimeWindowNode(snmpEngineId, bootsA, timeA);
            this.setTimeLine(snmpEngineId, node);
        }
        return updated;
    }

    protected void updateTimeWindows() {
        if (this.engineLookup.size() > 0) {
            int sec;
            long now = System.currentTimeMillis();
            long milli = now - this.startTime;
            long lostMillis = milli - (long)(sec = (int)(milli / 1000L)) * 1000L;
            if (lostMillis < 0L) {
                lostMillis = 0L;
            }
            this.startTime = now - lostMillis;
            Enumeration nodes = this.engineLookup.elements();
            while (nodes.hasMoreElements()) {
                TimeWindowNode node = (TimeWindowNode)nodes.nextElement();
                node.incrementSnmpEngineTime(sec);
            }
        } else {
            this.startTime = System.currentTimeMillis();
        }
    }

    protected String getKey(String host, int port) {
        return host + ":" + port;
    }

    protected TimeWindowNode getTimeLine(String snmpEngineId) {
        this.updateTimeWindows();
        TimeWindowNode node = (TimeWindowNode)this.engineLookup.get(snmpEngineId);
        return node;
    }

    protected TimeWindowNode setTimeLine(String snmpEngineId, TimeWindowNode newNode) {
        this.updateTimeWindows();
        this.engineLookup.put(snmpEngineId, newNode);
        if (AsnObject.debug > 4) {
            System.out.println();
            System.out.println("TimeWindow.setTimeLine(): snmpEngineId " + snmpEngineId + ", node " + newNode);
        }
        return newNode;
    }
}

