/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

class TimeWindowNode {
    private static final String version_id = "@(#)$Id: TimeWindowNode.java,v 3.8 2002/10/10 15:13:57 birgit Exp $ Copyright Westhawk Ltd";
    public static final int maxTime = Integer.MAX_VALUE;
    private String snmpEngineId;
    private int snmpEngineBoots = 0;
    private int snmpEngineTime = 0;
    private int latestReceivedEngineTime = 0;

    public TimeWindowNode(String engId) {
        this(engId, 0, 0);
    }

    public TimeWindowNode(String engId, int boots, int time) {
        this.snmpEngineId = engId;
        this.snmpEngineBoots = boots;
        this.snmpEngineTime = time;
        this.latestReceivedEngineTime = time;
    }

    public String getSnmpEngineId() {
        return this.snmpEngineId;
    }

    public void setSnmpEngineBoots(int newSnmpEngineBoots) {
        this.snmpEngineBoots = newSnmpEngineBoots;
    }

    public int getSnmpEngineBoots() {
        return this.snmpEngineBoots;
    }

    public void setSnmpEngineTime(int newSnmpEngineTime) {
        this.snmpEngineTime = newSnmpEngineTime;
        this.latestReceivedEngineTime = newSnmpEngineTime;
    }

    public int getSnmpEngineTime() {
        return this.snmpEngineTime;
    }

    public synchronized void incrementSnmpEngineTime(int incr) {
        this.snmpEngineTime += incr;
        if (this.snmpEngineTime > Integer.MAX_VALUE) {
            ++this.snmpEngineBoots;
            this.snmpEngineTime -= Integer.MAX_VALUE;
        }
    }

    public int getLatestReceivedEngineTime() {
        return this.latestReceivedEngineTime;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("[");
        buffer.append("engineId=").append(this.snmpEngineId);
        buffer.append(", engineBoots=").append(this.snmpEngineBoots);
        buffer.append(", engineTime=").append(this.snmpEngineTime);
        buffer.append(", latestReceivedEngineTime=").append(this.latestReceivedEngineTime);
        buffer.append("]");
        return buffer.toString();
    }
}

