/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.visual;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class LevelDraw
extends Canvas {
    private static final String version_id = "@(#)$Id: LevelDraw.java,v 1.1 2002/10/23 14:13:01 birgit Exp $ Copyright Westhawk Ltd";
    private boolean doScale = false;
    private Color fg = Color.black;
    private Color bg = Color.lightGray;
    private Color lbg = Color.white;
    private Color lfg = Color.orange;
    private double value = 0.0;
    private FontMetrics fm;
    private double dmax = Math.log(1000000.0) / Math.log(10.0);
    private Image image = null;
    private int width = 0;
    private int height = 0;
    private boolean isChanged = true;
    static final String[] xaxis = new String[]{"0 B/s", "10 B/s", "100 B/s", "1 KB/s", "10 KB/s", "100 KB/s", "1 MB/s"};
    static final int max = 1000000;
    static final int min = 0;
    static final String max_str = "1 MB/s";
    static final String min_str = "0";

    public void setValue(double v) {
        if (v != this.value) {
            this.value = v;
            this.isChanged = true;
            this.repaint();
        }
    }

    public double getValue() {
        return this.value;
    }

    public void addNotify() {
        super.addNotify();
        Font f = this.getFont();
        this.fm = this.getFontMetrics(f);
    }

    public void setScale(boolean b) {
        if (b != this.doScale) {
            this.doScale = b;
            this.isChanged = true;
            this.repaint();
        }
    }

    public void setForeground(Color c) {
        if (c != this.fg) {
            this.fg = c;
            this.isChanged = true;
            this.repaint();
        }
    }

    public void setBackground(Color c) {
        if (c != this.bg) {
            this.bg = c;
            this.isChanged = true;
            this.repaint();
        }
    }

    public void setLevelBackground(Color c) {
        if (c != this.lbg) {
            this.lbg = c;
            this.isChanged = true;
            this.repaint();
        }
    }

    public void setLevelForeground(Color c) {
        if (c != this.lfg) {
            this.lfg = c;
            this.isChanged = true;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        if (g != null) {
            int w = this.getSize().width - 1;
            int h = this.getSize().height - 1;
            if (w > 0 && h > 0) {
                if (this.image == null || this.width != w || this.height != h || this.isChanged) {
                    this.width = w;
                    this.height = h;
                    this.image = this.createImage(this.width, this.height);
                    this.drawImage(this.image, this.width, this.height);
                }
                g.drawImage(this.image, 0, 0, null);
            }
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private void drawImage(Image image, int w, int h) {
        Graphics g = image.getGraphics();
        g.setColor(this.bg);
        g.fillRect(0, 0, w, h);
        int fonth = this.fm.getHeight();
        int scale = (int)((double)(h - 2 * fonth) / this.dmax);
        int xl = this.doScale ? w / 2 - w / 8 : w / 8;
        int xr = w - w / 8;
        int yt = fonth;
        int yb = fonth + (int)((double)scale * this.dmax);
        int levelw = xr - xl;
        int levelh = yb - yt;
        g.setColor(this.lbg);
        g.fillRect(xl, yt, levelw, levelh);
        double dvalue = 0.0;
        if (this.value != 0.0) {
            dvalue = Math.log(this.value) / Math.log(10.0);
        }
        int l = (int)((double)scale * dvalue);
        g.setColor(this.lfg);
        g.fillRect(xl + 2, yb - l, levelw - 4, l);
        g.setColor(this.fg);
        if (this.doScale) {
            this.drawScale(g, xl, xr, yt, yb, scale);
        }
        int sw = this.fm.stringWidth(this.value + " B/s");
        int p = xl + (levelw - sw) / 2;
        g.drawString(this.value + " B/s", p, yb - l - 2);
    }

    private void drawScale(Graphics g, int xl, int xr, int yt, int yb, int scale) {
        int p;
        int sw;
        int y = yb;
        int x = xl;
        int i = 0;
        while ((double)i <= this.dmax) {
            g.drawLine(x - 2, y, x + 2, y);
            sw = this.fm.stringWidth(xaxis[i]);
            p = x - 2 - sw - 2;
            g.drawString(xaxis[i], p, y);
            y -= scale;
            ++i;
        }
        y = yt;
        g.drawLine(x - 2, y, x + 2, y);
        sw = this.fm.stringWidth(xaxis[6]);
        p = x - 2 - sw - 2;
        g.drawString(xaxis[6], p, y);
    }

    public Dimension getPreferredSize() {
        int w = 20;
        int h = 100;
        if (this.doScale) {
            w *= 3;
        }
        return new Dimension(w, h);
    }

    public Dimension getMinimumSize() {
        int w = 10;
        int h = 75;
        if (this.doScale) {
            w *= 3;
        }
        return new Dimension(w, h);
    }

    public String toString() {
        return this.getClass().getName() + "[" + ",value=" + this.value + "]";
    }
}

